/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.network;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.jms.Connection;
import javax.jms.MessageNotWriteableException;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import javax.jms.Session;
import javax.management.ObjectName;
import junit.framework.TestCase;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.StubConnection;
import org.apache.activemq.broker.TransportConnector;
import org.apache.activemq.broker.jmx.ManagementContext;
import org.apache.activemq.broker.jmx.QueueViewMBean;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQTextMessage;
import org.apache.activemq.command.Command;
import org.apache.activemq.command.ConnectionId;
import org.apache.activemq.command.ConnectionInfo;
import org.apache.activemq.command.ConsumerInfo;
import org.apache.activemq.command.DestinationInfo;
import org.apache.activemq.command.Message;
import org.apache.activemq.command.MessageAck;
import org.apache.activemq.command.MessageDispatch;
import org.apache.activemq.command.MessageId;
import org.apache.activemq.command.ProducerInfo;
import org.apache.activemq.command.SessionInfo;
import org.apache.activemq.network.DemandForwardingBridge;
import org.apache.activemq.network.NetworkBridgeConfiguration;
import org.apache.activemq.network.NetworkConnector;
import org.apache.activemq.transport.Transport;
import org.apache.activemq.transport.TransportFactory;
import org.apache.activemq.util.Wait;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BrokerNetworkWithStuckMessagesTest
extends TestCase {
    private static final Log LOG = LogFactory.getLog(BrokerNetworkWithStuckMessagesTest.class);
    private BrokerService localBroker;
    private BrokerService remoteBroker;
    private DemandForwardingBridge bridge;
    protected Map<String, BrokerService> brokers = new HashMap<String, BrokerService>();
    protected ArrayList connections = new ArrayList();
    protected TransportConnector connector;
    protected TransportConnector remoteConnector;
    protected long idGenerator;
    protected int msgIdGenerator;
    protected int tempDestGenerator;
    protected int maxWait = 4000;
    protected String queueName = "TEST";
    protected String amqDomain = "org.apache.activemq";

    protected void setUp() throws Exception {
        this.createBroker();
        this.createRemoteBroker();
        FileUtils.deleteDirectory((File)new File("activemq-data"));
        NetworkBridgeConfiguration config = new NetworkBridgeConfiguration();
        config.setBrokerName("local");
        config.setDispatchAsync(false);
        Transport localTransport = this.createTransport();
        Transport remoteTransport = this.createRemoteTransport();
        this.bridge = new DemandForwardingBridge(config, localTransport, remoteTransport);
        this.bridge.setBrokerService(this.localBroker);
        this.bridge.start();
        this.waitForBridgeFormation();
    }

    protected void waitForBridgeFormation() throws Exception {
        for (final BrokerService broker : this.brokers.values()) {
            if (broker.getNetworkConnectors().isEmpty()) continue;
            Wait.waitFor(new Wait.Condition(){

                public boolean isSatisified() throws Exception {
                    return !((NetworkConnector)broker.getNetworkConnectors().get(0)).activeBridges().isEmpty();
                }
            });
        }
    }

    protected void tearDown() throws Exception {
        this.bridge.stop();
        this.localBroker.stop();
        this.remoteBroker.stop();
    }

    public void testBrokerNetworkWithStuckMessages() throws Exception {
        Message message1;
        int sendNumMessages = 10;
        int receiveNumMessages = 5;
        StubConnection connection1 = this.createConnection();
        ConnectionInfo connectionInfo1 = this.createConnectionInfo();
        SessionInfo sessionInfo1 = this.createSessionInfo(connectionInfo1);
        ProducerInfo producerInfo = this.createProducerInfo(sessionInfo1);
        connection1.send((Command)connectionInfo1);
        connection1.send((Command)sessionInfo1);
        connection1.send((Command)producerInfo);
        ActiveMQDestination destinationInfo1 = null;
        for (int i = 0; i < sendNumMessages; ++i) {
            destinationInfo1 = this.createDestinationInfo(connection1, connectionInfo1, (byte)1);
            connection1.request((Command)this.createMessage(producerInfo, destinationInfo1, 1));
        }
        Object[] messages = this.browseQueueWithJmx(this.localBroker);
        BrokerNetworkWithStuckMessagesTest.assertEquals((int)sendNumMessages, (int)messages.length);
        StubConnection connection2 = this.createRemoteConnection();
        ConnectionInfo connectionInfo2 = this.createConnectionInfo();
        SessionInfo sessionInfo2 = this.createSessionInfo(connectionInfo2);
        connection2.send((Command)connectionInfo2);
        connection2.send((Command)sessionInfo2);
        ActiveMQDestination destinationInfo2 = this.createDestinationInfo(connection2, connectionInfo2, (byte)1);
        ConsumerInfo consumerInfo2 = this.createConsumerInfo(sessionInfo2, destinationInfo2);
        connection2.send((Command)consumerInfo2);
        for (int i = 0; i < receiveNumMessages; ++i) {
            message1 = this.receiveMessage(connection2);
            BrokerNetworkWithStuckMessagesTest.assertNotNull((Object)message1);
            connection2.send((Command)this.createAck(consumerInfo2, message1, 1, (byte)2));
            Object[] msgs1 = this.browseQueueWithJmx(this.remoteBroker);
            LOG.info((Object)("Found [" + msgs1.length + "] messages with JMX"));
        }
        messages = this.browseQueueWithJmx(this.localBroker);
        BrokerNetworkWithStuckMessagesTest.assertEquals((int)0, (int)messages.length);
        connection2.send((Command)consumerInfo2.createRemoveCommand());
        messages = this.browseQueueWithJmx(this.remoteBroker);
        BrokerNetworkWithStuckMessagesTest.assertEquals((int)5, (int)messages.length);
        ConsumerInfo consumerInfo1 = this.createConsumerInfo(sessionInfo1, destinationInfo1);
        connection1.send((Command)consumerInfo1);
        message1 = this.receiveMessage(connection1);
        BrokerNetworkWithStuckMessagesTest.assertNull((Object)message1);
        ConsumerInfo consumerInfo3 = this.createConsumerInfo(sessionInfo2, destinationInfo2);
        connection2.send((Command)consumerInfo3);
        int counter = 0;
        for (int i = 0; i < receiveNumMessages; ++i) {
            message1 = this.receiveMessage(connection2);
            BrokerNetworkWithStuckMessagesTest.assertNotNull((Object)message1);
            connection2.send((Command)this.createAck(consumerInfo3, message1, 1, (byte)2));
            ++counter;
        }
        BrokerNetworkWithStuckMessagesTest.assertEquals((int)receiveNumMessages, (int)counter);
        Thread.sleep(4000L);
        messages = this.browseQueueWithJmx(this.remoteBroker);
        BrokerNetworkWithStuckMessagesTest.assertEquals((int)0, (int)messages.length);
        connection2.send((Command)consumerInfo3.createRemoveCommand());
        connection1.stop();
        connection2.stop();
    }

    protected BrokerService createBroker() throws Exception {
        this.localBroker = new BrokerService();
        this.localBroker.setBrokerName("localhost");
        this.localBroker.setUseJmx(true);
        this.localBroker.setPersistenceAdapter(null);
        this.localBroker.setPersistent(false);
        this.connector = this.createConnector();
        this.localBroker.addConnector(this.connector);
        this.localBroker.start();
        this.localBroker.waitUntilStarted();
        this.localBroker.getManagementContext().setConnectorPort(2221);
        this.brokers.put(this.localBroker.getBrokerName(), this.localBroker);
        return this.localBroker;
    }

    protected BrokerService createRemoteBroker() throws Exception {
        this.remoteBroker = new BrokerService();
        this.remoteBroker.setBrokerName("remotehost");
        this.remoteBroker.setUseJmx(true);
        this.remoteBroker.setPersistenceAdapter(null);
        this.remoteBroker.setPersistent(false);
        this.remoteConnector = this.createRemoteConnector();
        this.remoteBroker.addConnector(this.remoteConnector);
        this.remoteBroker.waitUntilStarted();
        this.remoteBroker.getManagementContext().setConnectorPort(2222);
        this.brokers.put(this.remoteBroker.getBrokerName(), this.remoteBroker);
        return this.remoteBroker;
    }

    protected Transport createTransport() throws Exception {
        Transport transport = TransportFactory.connect((URI)this.connector.getServer().getConnectURI());
        return transport;
    }

    protected Transport createRemoteTransport() throws Exception {
        Transport transport = TransportFactory.connect((URI)this.remoteConnector.getServer().getConnectURI());
        return transport;
    }

    protected TransportConnector createConnector() throws Exception, IOException, URISyntaxException {
        return new TransportConnector(TransportFactory.bind((URI)new URI(this.getLocalURI())));
    }

    protected TransportConnector createRemoteConnector() throws Exception, IOException, URISyntaxException {
        return new TransportConnector(TransportFactory.bind((URI)new URI(this.getRemoteURI())));
    }

    protected String getRemoteURI() {
        return "vm://remotehost";
    }

    protected String getLocalURI() {
        return "vm://localhost";
    }

    protected StubConnection createConnection() throws Exception {
        Transport transport = TransportFactory.connect((URI)this.connector.getServer().getConnectURI());
        StubConnection connection = new StubConnection(transport);
        this.connections.add(connection);
        return connection;
    }

    protected StubConnection createRemoteConnection() throws Exception {
        Transport transport = TransportFactory.connect((URI)this.remoteConnector.getServer().getConnectURI());
        StubConnection connection = new StubConnection(transport);
        this.connections.add(connection);
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object[] browseQueueWithJms(BrokerService broker) throws Exception {
        Object[] messages = null;
        Connection connection = null;
        Session session = null;
        try {
            URI brokerUri = this.connector.getUri();
            ActiveMQConnectionFactory connectionFactory = new ActiveMQConnectionFactory(brokerUri.toString());
            connection = connectionFactory.createConnection();
            connection.start();
            session = connection.createSession(false, 1);
            Queue destination = session.createQueue(this.queueName);
            QueueBrowser browser = session.createBrowser(destination);
            ArrayList list = new ArrayList();
            Enumeration enumn = browser.getEnumeration();
            while (enumn.hasMoreElements()) {
                list.add(enumn.nextElement());
            }
            messages = list.toArray();
        }
        finally {
            if (session != null) {
                session.close();
            }
            if (connection != null) {
                connection.close();
            }
        }
        LOG.info((Object)("+Browsed with JMS: " + messages.length));
        return messages;
    }

    private Object[] browseQueueWithJmx(BrokerService broker) throws Exception {
        Hashtable<String, String> params = new Hashtable<String, String>();
        params.put("BrokerName", broker.getBrokerName());
        params.put("Type", "Queue");
        params.put("Destination", this.queueName);
        ObjectName queueObjectName = ObjectName.getInstance(this.amqDomain, params);
        ManagementContext mgmtCtx = broker.getManagementContext();
        QueueViewMBean queueView = (QueueViewMBean)mgmtCtx.newProxyInstance(queueObjectName, QueueViewMBean.class, true);
        Object[] messages = queueView.browse();
        LOG.info((Object)("+Browsed with JMX: " + messages.length));
        return messages;
    }

    protected ConnectionInfo createConnectionInfo() throws Exception {
        ConnectionInfo info = new ConnectionInfo();
        info.setConnectionId(new ConnectionId("connection:" + ++this.idGenerator));
        info.setClientId(info.getConnectionId().getValue());
        return info;
    }

    protected SessionInfo createSessionInfo(ConnectionInfo connectionInfo) throws Exception {
        SessionInfo info = new SessionInfo(connectionInfo, ++this.idGenerator);
        return info;
    }

    protected ProducerInfo createProducerInfo(SessionInfo sessionInfo) throws Exception {
        ProducerInfo info = new ProducerInfo(sessionInfo, ++this.idGenerator);
        return info;
    }

    protected ConsumerInfo createConsumerInfo(SessionInfo sessionInfo, ActiveMQDestination destination) throws Exception {
        ConsumerInfo info = new ConsumerInfo(sessionInfo, ++this.idGenerator);
        info.setBrowser(false);
        info.setDestination(destination);
        info.setPrefetchSize(1000);
        info.setDispatchAsync(false);
        return info;
    }

    protected DestinationInfo createTempDestinationInfo(ConnectionInfo connectionInfo, byte destinationType) {
        DestinationInfo info = new DestinationInfo();
        info.setConnectionId(connectionInfo.getConnectionId());
        info.setOperationType((byte)0);
        info.setDestination(ActiveMQDestination.createDestination((String)(info.getConnectionId() + ":" + ++this.tempDestGenerator), (byte)destinationType));
        return info;
    }

    protected ActiveMQDestination createDestinationInfo(StubConnection connection, ConnectionInfo connectionInfo1, byte destinationType) throws Exception {
        if ((destinationType & 4) != 0) {
            DestinationInfo info = this.createTempDestinationInfo(connectionInfo1, destinationType);
            connection.send((Command)info);
            return info.getDestination();
        }
        return ActiveMQDestination.createDestination((String)this.queueName, (byte)destinationType);
    }

    protected Message createMessage(ProducerInfo producerInfo, ActiveMQDestination destination, int deliveryMode) {
        Message message = this.createMessage(producerInfo, destination);
        message.setPersistent(deliveryMode == 2);
        return message;
    }

    protected Message createMessage(ProducerInfo producerInfo, ActiveMQDestination destination) {
        ActiveMQTextMessage message = new ActiveMQTextMessage();
        message.setMessageId(new MessageId(producerInfo, (long)(++this.msgIdGenerator)));
        message.setDestination(destination);
        message.setPersistent(false);
        try {
            message.setText("Test Message Payload.");
        }
        catch (MessageNotWriteableException e) {
            // empty catch block
        }
        return message;
    }

    protected MessageAck createAck(ConsumerInfo consumerInfo, Message msg, int count, byte ackType) {
        MessageAck ack = new MessageAck();
        ack.setAckType(ackType);
        ack.setConsumerId(consumerInfo.getConsumerId());
        ack.setDestination(msg.getDestination());
        ack.setLastMessageId(msg.getMessageId());
        ack.setMessageCount(count);
        return ack;
    }

    public Message receiveMessage(StubConnection connection) throws InterruptedException {
        return this.receiveMessage(connection, this.maxWait);
    }

    public Message receiveMessage(StubConnection connection, long timeout) throws InterruptedException {
        Object o;
        do {
            if ((o = connection.getDispatchQueue().poll(timeout, TimeUnit.MILLISECONDS)) != null) continue;
            return null;
        } while (!(o instanceof MessageDispatch));
        MessageDispatch dispatch = (MessageDispatch)o;
        if (dispatch.getMessage() == null) {
            return null;
        }
        dispatch.setMessage(dispatch.getMessage().copy());
        dispatch.getMessage().setRedeliveryCounter(dispatch.getRedeliveryCounter());
        return dispatch.getMessage();
    }
}

