/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.network;

import junit.framework.Test;
import junit.textui.TestRunner;
import org.apache.activemq.broker.StubConnection;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.Command;
import org.apache.activemq.command.ConnectionInfo;
import org.apache.activemq.command.ConsumerInfo;
import org.apache.activemq.command.Message;
import org.apache.activemq.command.ProducerInfo;
import org.apache.activemq.command.SessionInfo;
import org.apache.activemq.network.DemandForwardingBridge;
import org.apache.activemq.network.NetworkBridgeConfiguration;
import org.apache.activemq.network.NetworkTestSupport;

public class DemandForwardingBridgeFilterTest
extends NetworkTestSupport {
    private DemandForwardingBridge bridge;
    private StubConnection producerConnection;
    private ProducerInfo producerInfo;
    private StubConnection consumerConnection;
    private SessionInfo consumerSessionInfo;

    public void testWildcardOnExcludedDestination() throws Exception {
        this.bridge.setExcludedDestinations(new ActiveMQDestination[]{ActiveMQDestination.createDestination((String)"OTHER.>", (byte)2)});
        this.bridge.setDynamicallyIncludedDestinations(new ActiveMQDestination[]{ActiveMQDestination.createDestination((String)"TEST", (byte)1)});
        this.bridge.start();
        this.assertReceiveMessageOn("TEST", (byte)1);
        this.assertReceiveNoMessageOn("OTHER.T1", (byte)2);
    }

    public void testWildcardOnTwoExcludedDestination() throws Exception {
        this.bridge.setExcludedDestinations(new ActiveMQDestination[]{ActiveMQDestination.createDestination((String)"OTHER.>", (byte)1), ActiveMQDestination.createDestination((String)"TEST.X1", (byte)1)});
        this.bridge.setDynamicallyIncludedDestinations(new ActiveMQDestination[]{ActiveMQDestination.createDestination((String)"TEST.X2", (byte)1)});
        this.bridge.start();
        this.assertReceiveMessageOn("TEST.X2", (byte)1);
        this.assertReceiveNoMessageOn("OTHER.X1", (byte)1);
        this.assertReceiveNoMessageOn("TEST.X1", (byte)1);
    }

    public void testWildcardOnDynamicallyIncludedDestination() throws Exception {
        this.bridge.setDynamicallyIncludedDestinations(new ActiveMQDestination[]{ActiveMQDestination.createDestination((String)"OTHER.>", (byte)1), ActiveMQDestination.createDestination((String)"TEST.X2", (byte)1)});
        this.bridge.start();
        this.assertReceiveMessageOn("OTHER.X1", (byte)1);
        this.assertReceiveMessageOn("TEST.X2", (byte)1);
    }

    public void testDistinctTopicAndQueue() throws Exception {
        this.bridge.setExcludedDestinations(new ActiveMQDestination[]{ActiveMQDestination.createDestination((String)">", (byte)2)});
        this.bridge.setDynamicallyIncludedDestinations(new ActiveMQDestination[]{ActiveMQDestination.createDestination((String)">", (byte)1)});
        this.bridge.start();
        this.assertReceiveMessageOn("TEST", (byte)1);
        this.assertReceiveNoMessageOn("TEST", (byte)2);
    }

    public void testListOfExcludedDestinationWithWildcard() throws Exception {
        this.bridge.setExcludedDestinations(new ActiveMQDestination[]{ActiveMQDestination.createDestination((String)"OTHER.>", (byte)2), ActiveMQDestination.createDestination((String)"TEST.*", (byte)2)});
        this.bridge.setDynamicallyIncludedDestinations(new ActiveMQDestination[]{ActiveMQDestination.createDestination((String)"TEST.X1", (byte)1)});
        this.bridge.start();
        this.assertReceiveMessageOn("TEST.X1", (byte)1);
        this.assertReceiveNoMessageOn("OTHER.T1", (byte)2);
        this.assertReceiveNoMessageOn("OTHER.T2", (byte)2);
    }

    private void assertReceiveMessageOn(String destinationName, byte destinationType) throws Exception, InterruptedException {
        ActiveMQDestination destination = ActiveMQDestination.createDestination((String)destinationName, (byte)destinationType);
        this.producerConnection.send((Command)this.createMessage(this.producerInfo, destination, destinationType));
        Message m = this.createConsumerAndReceiveMessage(destination);
        DemandForwardingBridgeFilterTest.assertNotNull((Object)m);
    }

    private void assertReceiveNoMessageOn(String destinationName, byte destinationType) throws Exception, InterruptedException {
        ActiveMQDestination destination = ActiveMQDestination.createDestination((String)destinationName, (byte)destinationType);
        this.producerConnection.send((Command)this.createMessage(this.producerInfo, destination, destinationType));
        Message m = this.createConsumerAndReceiveMessage(destination);
        DemandForwardingBridgeFilterTest.assertNull((Object)m);
    }

    private Message createConsumerAndReceiveMessage(ActiveMQDestination destination) throws Exception {
        ConsumerInfo consumerInfo = this.createConsumerInfo(this.consumerSessionInfo, destination);
        this.consumerConnection.send((Command)consumerInfo);
        Message m = this.receiveMessage(this.consumerConnection);
        return m;
    }

    protected void setUp() throws Exception {
        super.setUp();
        NetworkBridgeConfiguration config = new NetworkBridgeConfiguration();
        config.setBrokerName("local");
        config.setDispatchAsync(false);
        this.bridge = new DemandForwardingBridge(config, this.createTransport(), this.createRemoteTransport());
        this.bridge.setBrokerService(this.broker);
        this.producerConnection = this.createConnection();
        ConnectionInfo producerConnectionInfo = this.createConnectionInfo();
        SessionInfo producerSessionInfo = this.createSessionInfo(producerConnectionInfo);
        this.producerInfo = this.createProducerInfo(producerSessionInfo);
        this.producerConnection.send((Command)producerConnectionInfo);
        this.producerConnection.send((Command)producerSessionInfo);
        this.producerConnection.send((Command)this.producerInfo);
        this.consumerConnection = this.createRemoteConnection();
        ConnectionInfo consumerConnectionInfo = this.createConnectionInfo();
        this.consumerSessionInfo = this.createSessionInfo(consumerConnectionInfo);
        this.consumerConnection.send((Command)consumerConnectionInfo);
        this.consumerConnection.send((Command)this.consumerSessionInfo);
    }

    protected void tearDown() throws Exception {
        this.bridge.stop();
        super.tearDown();
    }

    public static Test suite() {
        return DemandForwardingBridgeFilterTest.suite(DemandForwardingBridgeFilterTest.class);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)DemandForwardingBridgeFilterTest.suite());
    }
}

