/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.network;

import java.net.MalformedURLException;
import java.util.Set;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.network.NetworkConnector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;

public class DuplexNetworkMBeanTest {
    protected static final Log LOG = LogFactory.getLog(DuplexNetworkMBeanTest.class);
    protected final int numRestarts = 3;

    protected BrokerService createBroker() throws Exception {
        BrokerService broker = new BrokerService();
        broker.setBrokerName("broker");
        broker.addConnector("tcp://localhost:61617?transport.reuseAddress=true");
        return broker;
    }

    protected BrokerService createNetworkedBroker() throws Exception {
        BrokerService broker = new BrokerService();
        broker.setBrokerName("networkedBroker");
        broker.addConnector("tcp://localhost:62617?transport.reuseAddress=true");
        NetworkConnector networkConnector = broker.addNetworkConnector("static:(tcp://localhost:61617?wireFormat.maxInactivityDuration=500)?useExponentialBackOff=false");
        networkConnector.setDuplex(true);
        return broker;
    }

    @Test
    public void testMbeanPresenceOnNetworkBrokerRestart() throws Exception {
        BrokerService broker = this.createBroker();
        broker.start();
        Assert.assertEquals((long)1L, (long)this.countMbeans(broker, "Connector", 30000));
        Assert.assertEquals((long)0L, (long)this.countMbeans(broker, "Connection"));
        BrokerService networkedBroker = null;
        for (int i = 0; i < 3; ++i) {
            networkedBroker = this.createNetworkedBroker();
            networkedBroker.start();
            Assert.assertEquals((long)1L, (long)this.countMbeans(networkedBroker, "NetworkBridge", 2000));
            Assert.assertEquals((long)1L, (long)this.countMbeans(broker, "NetworkBridge", 2000));
            Assert.assertEquals((long)1L, (long)this.countMbeans(broker, "Connection"));
            networkedBroker.stop();
            networkedBroker.waitUntilStopped();
            Assert.assertEquals((long)0L, (long)this.countMbeans(networkedBroker, "stopped"));
            Assert.assertEquals((long)0L, (long)this.countMbeans(broker, "NetworkBridge"));
        }
        Assert.assertEquals((long)0L, (long)this.countMbeans(networkedBroker, "NetworkBridge"));
        Assert.assertEquals((long)0L, (long)this.countMbeans(networkedBroker, "Connector"));
        Assert.assertEquals((long)0L, (long)this.countMbeans(networkedBroker, "Connection"));
        Assert.assertEquals((long)1L, (long)this.countMbeans(broker, "Connector"));
        broker.stop();
        broker.waitUntilStopped();
    }

    @Test
    public void testMbeanPresenceOnBrokerRestart() throws Exception {
        BrokerService networkedBroker = this.createNetworkedBroker();
        networkedBroker.start();
        Assert.assertEquals((long)1L, (long)this.countMbeans(networkedBroker, "Connector", 30000));
        Assert.assertEquals((long)0L, (long)this.countMbeans(networkedBroker, "Connection"));
        BrokerService broker = null;
        for (int i = 0; i < 3; ++i) {
            broker = this.createBroker();
            broker.start();
            Assert.assertEquals((long)1L, (long)this.countMbeans(networkedBroker, "NetworkBridge", 5000));
            Assert.assertEquals((String)("restart number: " + i), (long)1L, (long)this.countMbeans(broker, "Connection", 10000));
            broker.stop();
            broker.waitUntilStopped();
            Assert.assertEquals((long)0L, (long)this.countMbeans(broker, "stopped"));
        }
        Assert.assertEquals((long)1L, (long)this.countMbeans(networkedBroker, "Connector"));
        Assert.assertEquals((long)0L, (long)this.countMbeans(networkedBroker, "Connection"));
        Assert.assertEquals((long)0L, (long)this.countMbeans(broker, "Connection"));
        networkedBroker.stop();
        networkedBroker.waitUntilStopped();
    }

    private int countMbeans(BrokerService broker, String type) throws Exception {
        return this.countMbeans(broker, type, 0);
    }

    private int countMbeans(BrokerService broker, String type, int timeout) throws Exception {
        long expiryTime = System.currentTimeMillis() + (long)timeout;
        ObjectName beanName = new ObjectName("org.apache.activemq:BrokerName=" + broker.getBrokerName() + ",Type=" + type + ",*");
        Set mbeans = null;
        int count = 0;
        do {
            if (timeout > 0) {
                Thread.sleep(100L);
            }
            LOG.info((Object)("Query name: " + beanName));
            mbeans = broker.getManagementContext().queryNames(beanName, null);
            if (mbeans != null) {
                count = mbeans.size();
                continue;
            }
            this.logAllMbeans(broker);
        } while ((mbeans == null || mbeans.isEmpty()) && expiryTime > System.currentTimeMillis());
        if (timeout > 0) {
            Assume.assumeNotNull((Object[])new Object[]{mbeans});
        }
        return count;
    }

    private void logAllMbeans(BrokerService broker) throws MalformedURLException {
        try {
            Set all = broker.getManagementContext().queryNames(null, null);
            LOG.info((Object)("Total MBean count=" + all.size()));
            for (Object o : all) {
                ObjectInstance bean = (ObjectInstance)o;
                LOG.info((Object)bean.getObjectName());
            }
        }
        catch (Exception ignored) {
            LOG.warn((Object)("getMBeanServer ex: " + ignored));
        }
    }
}

