/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.network;

import java.io.File;
import java.net.MalformedURLException;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.Session;
import javax.jms.Topic;
import javax.jms.TopicSubscriber;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.ActiveMQPrefetchPolicy;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.TransportConnector;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQTopic;
import org.apache.activemq.network.NetworkConnector;
import org.apache.activemq.store.PersistenceAdapter;
import org.apache.activemq.store.kahadb.KahaDBPersistenceAdapter;
import org.apache.activemq.util.Wait;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;

public class NetworkBrokerDetachTest {
    private static final String BROKER_NAME = "broker";
    private static final String REM_BROKER_NAME = "networkedBroker";
    private static final String DESTINATION_NAME = "testQ";
    private static final int NUM_CONSUMERS = 1;
    protected static final Log LOG = LogFactory.getLog(NetworkBrokerDetachTest.class);
    protected final int numRestarts = 3;
    protected final int networkTTL = 2;
    protected final boolean dynamicOnly = false;
    protected BrokerService broker;
    protected BrokerService networkedBroker;

    protected BrokerService createBroker() throws Exception {
        BrokerService broker = new BrokerService();
        broker.setBrokerName(BROKER_NAME);
        this.configureBroker(broker);
        broker.addConnector("tcp://localhost:61617");
        NetworkConnector networkConnector = broker.addNetworkConnector("static:(tcp://localhost:62617?wireFormat.maxInactivityDuration=500)?useExponentialBackOff=false");
        this.configureNetworkConnector(networkConnector);
        return broker;
    }

    protected BrokerService createNetworkedBroker() throws Exception {
        BrokerService broker = new BrokerService();
        broker.setBrokerName(REM_BROKER_NAME);
        this.configureBroker(broker);
        broker.getManagementContext().setCreateConnector(false);
        broker.addConnector("tcp://localhost:62617");
        NetworkConnector networkConnector = broker.addNetworkConnector("static:(tcp://localhost:61617?wireFormat.maxInactivityDuration=500)?useExponentialBackOff=false");
        this.configureNetworkConnector(networkConnector);
        return broker;
    }

    private void configureNetworkConnector(NetworkConnector networkConnector) {
        networkConnector.setDuplex(false);
        networkConnector.setNetworkTTL(2);
        networkConnector.setDynamicOnly(false);
    }

    protected void configureBroker(BrokerService broker) throws Exception {
        KahaDBPersistenceAdapter persistenceAdapter = new KahaDBPersistenceAdapter();
        persistenceAdapter.setDirectory(new File("target/activemq-data/kahadb/" + broker.getBrokerName() + "NetworBrokerDetatchTest"));
        broker.setPersistenceAdapter((PersistenceAdapter)persistenceAdapter);
    }

    @Before
    public void init() throws Exception {
        this.broker = this.createBroker();
        this.broker.setDeleteAllMessagesOnStartup(true);
        this.broker.start();
        this.networkedBroker = this.createNetworkedBroker();
        this.networkedBroker.setDeleteAllMessagesOnStartup(true);
        this.networkedBroker.start();
    }

    @After
    public void cleanup() throws Exception {
        this.networkedBroker.stop();
        this.networkedBroker.waitUntilStopped();
        this.broker.stop();
        this.broker.waitUntilStopped();
    }

    @Test
    public void testNetworkedBrokerDetach() throws Exception {
        LOG.info((Object)"Creating Consumer on the networked broker ...");
        ConnectionFactory consFactory = this.createConnectionFactory(this.networkedBroker);
        Connection consConn = consFactory.createConnection();
        Session consSession = consConn.createSession(false, 1);
        ActiveMQDestination destination = (ActiveMQDestination)consSession.createQueue(DESTINATION_NAME);
        for (int i = 0; i < 1; ++i) {
            consSession.createConsumer((Destination)destination);
        }
        Assert.assertTrue((String)"got expected consumer count from mbean within time limit", (boolean)this.verifyConsumerCount(1L, destination, this.broker));
        LOG.info((Object)"Stopping Consumer on the networked broker ...");
        consConn.close();
        Assert.assertTrue((String)"got expected 0 count from mbean within time limit", (boolean)this.verifyConsumerCount(0L, destination, this.broker));
    }

    @Test
    public void testNetworkedBrokerDurableSubAfterRestart() throws Exception {
        final AtomicInteger count = new AtomicInteger(0);
        MessageListener counter = new MessageListener(){

            public void onMessage(Message message) {
                count.incrementAndGet();
            }
        };
        LOG.info((Object)"Creating durable consumer on each broker ...");
        ActiveMQTopic destination = this.registerDurableConsumer(this.networkedBroker, counter);
        this.registerDurableConsumer(this.broker, counter);
        Assert.assertTrue((String)"got expected consumer count from local broker mbean within time limit", (boolean)this.verifyConsumerCount(2L, (ActiveMQDestination)destination, this.broker));
        Assert.assertTrue((String)"got expected consumer count from network broker mbean within time limit", (boolean)this.verifyConsumerCount(2L, (ActiveMQDestination)destination, this.networkedBroker));
        this.sendMessageTo(destination, this.broker);
        Assert.assertTrue((String)"Got one message on each", (boolean)this.verifyMessageCount(2, count));
        LOG.info((Object)"Stopping brokerTwo...");
        this.networkedBroker.stop();
        this.networkedBroker.waitUntilStopped();
        LOG.info((Object)"restarting  broker Two...");
        this.networkedBroker = this.createNetworkedBroker();
        this.networkedBroker.start();
        LOG.info((Object)"Recreating durable Consumer on the broker after restart...");
        this.registerDurableConsumer(this.networkedBroker, counter);
        TimeUnit.SECONDS.sleep(5L);
        this.sendMessageTo(destination, this.broker);
        Assert.assertTrue((String)"got expected consumer count from local broker mbean within time limit", (boolean)this.verifyConsumerCount(2L, (ActiveMQDestination)destination, this.broker));
        Assert.assertTrue((String)"got expected consumer count from network broker mbean within time limit", (boolean)this.verifyConsumerCount(2L, (ActiveMQDestination)destination, this.networkedBroker));
        Assert.assertTrue((String)"got no inactive subs on broker", (boolean)this.verifyDurableConsumerCount(0L, this.broker));
        Assert.assertTrue((String)"got no inactive subs on other broker", (boolean)this.verifyDurableConsumerCount(0L, this.networkedBroker));
        Assert.assertTrue((String)"Got two more messages after restart", (boolean)this.verifyMessageCount(4, count));
        TimeUnit.SECONDS.sleep(1L);
        Assert.assertTrue((String)"still Got just two more messages", (boolean)this.verifyMessageCount(4, count));
    }

    private boolean verifyMessageCount(final int i, final AtomicInteger count) throws Exception {
        return Wait.waitFor(new Wait.Condition(){

            public boolean isSatisified() throws Exception {
                return i == count.get();
            }
        });
    }

    private ActiveMQTopic registerDurableConsumer(BrokerService brokerService, MessageListener listener) throws Exception {
        ConnectionFactory factory = this.createConnectionFactory(brokerService);
        Connection connection = factory.createConnection();
        connection.setClientID("DurableOne");
        connection.start();
        Session session = connection.createSession(false, 1);
        ActiveMQTopic destination = (ActiveMQTopic)session.createTopic(DESTINATION_NAME);
        TopicSubscriber sub = session.createDurableSubscriber((Topic)destination, "SubOne" + brokerService.getBrokerName());
        sub.setMessageListener(listener);
        return destination;
    }

    private void sendMessageTo(ActiveMQTopic destination, BrokerService brokerService) throws Exception {
        ConnectionFactory factory = this.createConnectionFactory(brokerService);
        Connection conn = factory.createConnection();
        conn.start();
        Session session = conn.createSession(false, 1);
        session.createProducer((Destination)destination).send((Message)session.createTextMessage("Hi"));
        conn.close();
    }

    protected ConnectionFactory createConnectionFactory(BrokerService broker) throws Exception {
        String url = ((TransportConnector)broker.getTransportConnectors().get(0)).getServer().getConnectURI().toString();
        ActiveMQConnectionFactory connectionFactory = new ActiveMQConnectionFactory(url);
        connectionFactory.setOptimizedMessageDispatch(true);
        connectionFactory.setCopyMessageOnSend(false);
        connectionFactory.setUseCompression(false);
        connectionFactory.setDispatchAsync(false);
        connectionFactory.setUseAsyncSend(false);
        connectionFactory.setOptimizeAcknowledge(false);
        connectionFactory.setWatchTopicAdvisories(true);
        ActiveMQPrefetchPolicy qPrefetchPolicy = new ActiveMQPrefetchPolicy();
        qPrefetchPolicy.setQueuePrefetch(100);
        qPrefetchPolicy.setTopicPrefetch(1000);
        connectionFactory.setPrefetchPolicy(qPrefetchPolicy);
        connectionFactory.setAlwaysSyncSend(true);
        return connectionFactory;
    }

    private boolean verifyConsumerCount(final long expectedCount, final ActiveMQDestination destination, final BrokerService broker) throws Exception {
        return Wait.waitFor(new Wait.Condition(){

            public boolean isSatisified() throws Exception {
                boolean result = false;
                try {
                    Object consumers = broker.getManagementContext().getAttribute(NetworkBrokerDetachTest.this.getObjectName(broker.getBrokerName(), destination.isQueue() ? "Queue" : "Topic", "Destination=" + destination.getPhysicalName()), "ConsumerCount");
                    if (consumers != null) {
                        LOG.info((Object)("Consumers for " + destination.getPhysicalName() + " on " + broker + " : " + consumers));
                        if (expectedCount == (Long)consumers) {
                            result = true;
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return result;
            }
        });
    }

    private boolean verifyDurableConsumerCount(final long expectedCount, final BrokerService broker) throws Exception {
        return Wait.waitFor(new Wait.Condition(){

            public boolean isSatisified() throws Exception {
                Set subs;
                boolean result = false;
                MBeanServerConnection mbsc = NetworkBrokerDetachTest.this.getMBeanServerConnection();
                if (mbsc != null && (subs = broker.getManagementContext().queryNames(NetworkBrokerDetachTest.this.getObjectName(broker.getBrokerName(), "Subscription", "active=false,*"), null)) != null) {
                    LOG.info((Object)("inactive durable subs on " + broker + " : " + subs));
                    if (expectedCount == (long)subs.size()) {
                        result = true;
                    }
                }
                return result;
            }
        });
    }

    private MBeanServerConnection getMBeanServerConnection() throws MalformedURLException {
        JMXServiceURL url = new JMXServiceURL("service:jmx:rmi:///jndi/rmi://localhost:1099/jmxrmi");
        MBeanServerConnection mbsc = null;
        try {
            JMXConnector jmxc = JMXConnectorFactory.connect(url, null);
            mbsc = jmxc.getMBeanServerConnection();
        }
        catch (Exception ignored) {
            LOG.warn((Object)("getMBeanServer ex: " + ignored));
        }
        Assume.assumeNotNull((Object[])new Object[]{mbsc});
        return mbsc;
    }

    private ObjectName getObjectName(String brokerName, String type, String pattern) throws Exception {
        ObjectName beanName = new ObjectName("org.apache.activemq:BrokerName=" + brokerName + ",Type=" + type + "," + pattern);
        return beanName;
    }
}

