/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.perf;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.jms.BytesMessage;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Session;
import org.apache.activemq.perf.PerfRate;

public class PerfProducer
implements Runnable {
    protected Connection connection;
    protected MessageProducer producer;
    protected PerfRate rate = new PerfRate();
    private final byte[] payload;
    private Session session;
    private final CountDownLatch stopped = new CountDownLatch(1);
    private boolean running;
    private final boolean transacted;
    private int sleep = 0;

    public PerfProducer(ConnectionFactory fac, Destination dest, byte[] payload) throws JMSException {
        this(fac, dest, payload, false);
    }

    public PerfProducer(ConnectionFactory fac, Destination dest, byte[] payload, boolean transacted) throws JMSException {
        this.connection = fac.createConnection();
        this.transacted = transacted;
        this.session = transacted ? this.connection.createSession(true, 0) : this.connection.createSession(false, 1);
        this.producer = this.session.createProducer(dest);
        this.payload = payload;
    }

    public void setDeliveryMode(int mode) throws JMSException {
        this.producer.setDeliveryMode(mode);
    }

    public void setTimeToLive(int ttl) throws JMSException {
        this.producer.setTimeToLive((long)ttl);
    }

    public void shutDown() throws JMSException {
        this.connection.close();
    }

    public PerfRate getRate() {
        return this.rate;
    }

    public synchronized void start() throws JMSException {
        if (!this.running) {
            this.rate.reset();
            this.running = true;
            this.connection.start();
            Thread t = new Thread(this);
            t.setName("Producer");
            t.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws JMSException, InterruptedException {
        PerfProducer perfProducer = this;
        synchronized (perfProducer) {
            this.running = false;
        }
        this.stopped.await(1L, TimeUnit.SECONDS);
        this.connection.stop();
    }

    public synchronized boolean isRunning() {
        return this.running;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            while (this.isRunning()) {
                BytesMessage msg = this.session.createBytesMessage();
                msg.writeBytes(this.payload);
                this.producer.send((Message)msg);
                if (this.transacted) {
                    this.session.commit();
                }
                this.rate.increment();
                if (this.sleep <= 0) continue;
                Thread.sleep(this.sleep);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        finally {
            this.stopped.countDown();
        }
    }

    public int getSleep() {
        return this.sleep;
    }

    public void setSleep(int sleep) {
        this.sleep = sleep;
    }
}

