/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.security;

import java.util.List;
import java.util.Set;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.command.ActiveMQTopic;
import org.apache.activemq.jaas.GroupPrincipal;
import org.apache.activemq.security.CachedLDAPAuthorizationMap;
import org.apache.directory.ldap.client.api.LdapConnection;
import org.apache.directory.ldap.client.api.message.BindResponse;
import org.apache.directory.ldap.client.api.message.ModifyDnResponse;
import org.apache.directory.ldap.client.api.message.ModifyRequest;
import org.apache.directory.server.annotations.CreateLdapServer;
import org.apache.directory.server.annotations.CreateTransport;
import org.apache.directory.server.core.annotations.ApplyLdifFiles;
import org.apache.directory.server.core.integ.AbstractLdapTestUnit;
import org.apache.directory.server.core.integ.FrameworkRunner;
import org.apache.directory.shared.ldap.ldif.LdifEntry;
import org.apache.directory.shared.ldap.ldif.LdifReader;
import org.apache.directory.shared.ldap.message.ResultCodeEnum;
import org.apache.directory.shared.ldap.name.DN;
import org.apache.directory.shared.ldap.name.RDN;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=FrameworkRunner.class)
@CreateLdapServer(transports={@CreateTransport(protocol="LDAP")})
@ApplyLdifFiles(value={"org/apache/activemq/security/activemq-apacheds.ldif"})
public class CachedLDAPAuthorizationModuleTest
extends AbstractLdapTestUnit {
    static final GroupPrincipal GUESTS = new GroupPrincipal("guests");
    static final GroupPrincipal USERS = new GroupPrincipal("users");
    static final GroupPrincipal ADMINS = new GroupPrincipal("admins");

    @Test
    public void testQuery() throws Exception {
        CachedLDAPAuthorizationMap map = new CachedLDAPAuthorizationMap();
        map.query();
        Set readACLs = map.getReadACLs((ActiveMQDestination)new ActiveMQQueue("TEST.FOO"));
        Assert.assertEquals((String)("set size: " + readACLs), (long)2L, (long)readACLs.size());
        Assert.assertTrue((String)"Contains admin group", (boolean)readACLs.contains(ADMINS));
        Assert.assertTrue((String)"Contains users group", (boolean)readACLs.contains(USERS));
        Set failedACLs = map.getReadACLs((ActiveMQDestination)new ActiveMQQueue("FAILED"));
        Assert.assertEquals((String)("set size: " + failedACLs), (long)0L, (long)failedACLs.size());
    }

    @Test
    public void testWildcards() throws Exception {
        CachedLDAPAuthorizationMap map1 = new CachedLDAPAuthorizationMap();
        map1.query();
        Set fooACLs = map1.getReadACLs((ActiveMQDestination)new ActiveMQQueue("FOO.1"));
        Assert.assertEquals((String)("set size: " + fooACLs), (long)2L, (long)fooACLs.size());
        Assert.assertTrue((String)"Contains admin group", (boolean)fooACLs.contains(ADMINS));
        Assert.assertTrue((String)"Contains users group", (boolean)fooACLs.contains(USERS));
        CachedLDAPAuthorizationMap map2 = new CachedLDAPAuthorizationMap();
        map2.query();
        Set barACLs = map2.getReadACLs((ActiveMQDestination)new ActiveMQQueue("BAR.2"));
        Assert.assertEquals((String)("set size: " + barACLs), (long)2L, (long)barACLs.size());
        Assert.assertTrue((String)"Contains admin group", (boolean)barACLs.contains(ADMINS));
        Assert.assertTrue((String)"Contains users group", (boolean)barACLs.contains(USERS));
    }

    @Test
    public void testAdvisory() throws Exception {
        CachedLDAPAuthorizationMap map = new CachedLDAPAuthorizationMap();
        map.query();
        Set readACLs = map.getReadACLs((ActiveMQDestination)new ActiveMQTopic("ActiveMQ.Advisory.Connection"));
        Assert.assertEquals((String)("set size: " + readACLs), (long)2L, (long)readACLs.size());
        Assert.assertTrue((String)"Contains admin group", (boolean)readACLs.contains(ADMINS));
        Assert.assertTrue((String)"Contains users group", (boolean)readACLs.contains(USERS));
    }

    @Test
    public void testTemporary() throws Exception {
        CachedLDAPAuthorizationMap map = new CachedLDAPAuthorizationMap();
        map.query();
        Thread.sleep(1000L);
        Set readACLs = map.getTempDestinationReadACLs();
        Assert.assertEquals((String)("set size: " + readACLs), (long)2L, (long)readACLs.size());
        Assert.assertTrue((String)"Contains admin group", (boolean)readACLs.contains(ADMINS));
        Assert.assertTrue((String)"Contains users group", (boolean)readACLs.contains(USERS));
    }

    @Test
    public void testAdd() throws Exception {
        CachedLDAPAuthorizationMap map = new CachedLDAPAuthorizationMap();
        map.query();
        Set failedACLs = map.getReadACLs((ActiveMQDestination)new ActiveMQQueue("FAILED"));
        Assert.assertEquals((String)("set size: " + failedACLs), (long)0L, (long)failedACLs.size());
        LdapConnection connection = new LdapConnection("localhost", 1024);
        BindResponse bindResponse = connection.bind("uid=admin,ou=system", "secret");
        Assert.assertNotNull((Object)bindResponse);
        Assert.assertEquals((Object)ResultCodeEnum.SUCCESS, (Object)bindResponse.getLdapResult().getResultCode());
        Assert.assertTrue((boolean)connection.isAuthenticated());
        LdifReader reader = new LdifReader(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("org/apache/activemq/security/add.ldif"));
        List entries = service.getTestEntries();
        for (LdifEntry entry : reader) {
            connection.add(entry.getEntry());
        }
        Thread.sleep(2000L);
        failedACLs = map.getReadACLs((ActiveMQDestination)new ActiveMQQueue("FAILED"));
        Assert.assertEquals((String)("set size: " + failedACLs), (long)2L, (long)failedACLs.size());
        connection.close();
    }

    @Test
    public void testRemove() throws Exception {
        CachedLDAPAuthorizationMap map = new CachedLDAPAuthorizationMap();
        map.query();
        Set failedACLs = map.getReadACLs((ActiveMQDestination)new ActiveMQQueue("TEST.FOO"));
        Assert.assertEquals((String)("set size: " + failedACLs), (long)2L, (long)failedACLs.size());
        LdapConnection connection = new LdapConnection("localhost", 1024);
        BindResponse bindResponse = connection.bind("uid=admin,ou=system", "secret");
        Assert.assertNotNull((Object)bindResponse);
        Assert.assertEquals((Object)ResultCodeEnum.SUCCESS, (Object)bindResponse.getLdapResult().getResultCode());
        Assert.assertTrue((boolean)connection.isAuthenticated());
        LdifReader reader = new LdifReader(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("org/apache/activemq/security/delete.ldif"));
        List entries = service.getTestEntries();
        for (LdifEntry entry : reader) {
            connection.delete(entry.getDn());
        }
        Thread.sleep(2000L);
        failedACLs = map.getReadACLs((ActiveMQDestination)new ActiveMQQueue("TEST.FOO"));
        Assert.assertEquals((String)("set size: " + failedACLs), (long)0L, (long)failedACLs.size());
        connection.close();
    }

    @Test
    public void testRename() throws Exception {
        CachedLDAPAuthorizationMap map = new CachedLDAPAuthorizationMap();
        map.query();
        Set failedACLs = map.getReadACLs((ActiveMQDestination)new ActiveMQQueue("TEST.FOO"));
        Assert.assertEquals((String)("set size: " + failedACLs), (long)2L, (long)failedACLs.size());
        LdapConnection connection = new LdapConnection("localhost", 1024);
        BindResponse bindResponse = connection.bind("uid=admin,ou=system", "secret");
        Assert.assertNotNull((Object)bindResponse);
        Assert.assertEquals((Object)ResultCodeEnum.SUCCESS, (Object)bindResponse.getLdapResult().getResultCode());
        Assert.assertTrue((boolean)connection.isAuthenticated());
        ModifyDnResponse resp = connection.rename(new DN("cn=TEST.FOO,ou=Queue,ou=Destination,ou=ActiveMQ,ou=system"), new RDN("cn=TEST.BAR"));
        Thread.sleep(2000L);
        failedACLs = map.getReadACLs((ActiveMQDestination)new ActiveMQQueue("TEST.FOO"));
        Assert.assertEquals((String)("set size: " + failedACLs), (long)0L, (long)failedACLs.size());
        failedACLs = map.getReadACLs((ActiveMQDestination)new ActiveMQQueue("TEST.BAR"));
        Assert.assertEquals((String)("set size: " + failedACLs), (long)2L, (long)failedACLs.size());
        connection.close();
    }

    @Test
    public void testChange() throws Exception {
        CachedLDAPAuthorizationMap map = new CachedLDAPAuthorizationMap();
        map.query();
        Set failedACLs = map.getReadACLs((ActiveMQDestination)new ActiveMQQueue("TEST.FOO"));
        Assert.assertEquals((String)("set size: " + failedACLs), (long)2L, (long)failedACLs.size());
        LdapConnection connection = new LdapConnection("localhost", 1024);
        BindResponse bindResponse = connection.bind("uid=admin,ou=system", "secret");
        Assert.assertNotNull((Object)bindResponse);
        Assert.assertEquals((Object)ResultCodeEnum.SUCCESS, (Object)bindResponse.getLdapResult().getResultCode());
        Assert.assertTrue((boolean)connection.isAuthenticated());
        DN dn = new DN("cn=read,cn=TEST.FOO,ou=Queue,ou=Destination,ou=ActiveMQ,ou=system");
        ModifyRequest request = new ModifyRequest(dn);
        request.remove("member", new String[]{"cn=users"});
        connection.modify(request);
        Thread.sleep(2000L);
        failedACLs = map.getReadACLs((ActiveMQDestination)new ActiveMQQueue("TEST.FOO"));
        Assert.assertEquals((String)("set size: " + failedACLs), (long)1L, (long)failedACLs.size());
        connection.close();
    }
}

