/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.security;

import java.net.URI;
import javax.jms.Connection;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Session;
import javax.jms.TemporaryTopic;
import javax.management.ObjectName;
import junit.framework.Test;
import junit.textui.TestRunner;
import org.apache.activemq.broker.BrokerFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.jmx.TopicViewMBean;
import org.apache.activemq.command.ActiveMQMessage;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.security.SecurityTestSupport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SimpleAuthenticationPluginTest
extends SecurityTestSupport {
    private static final Log LOG = LogFactory.getLog(SimpleAuthenticationPluginTest.class);

    public static Test suite() {
        return SimpleAuthenticationPluginTest.suite(SimpleAuthenticationPluginTest.class);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)SimpleAuthenticationPluginTest.suite());
    }

    protected BrokerService createBroker() throws Exception {
        return this.createBroker("org/apache/activemq/security/simple-auth-broker.xml");
    }

    protected BrokerService createBroker(String uri) throws Exception {
        LOG.info((Object)("Loading broker configuration from the classpath with URI: " + uri));
        return BrokerFactory.createBroker((URI)new URI("xbean:" + uri));
    }

    public void initCombosForTestPredefinedDestinations() {
        this.addCombinationValues("userName", new Object[]{"guest"});
        this.addCombinationValues("password", new Object[]{"password"});
        this.addCombinationValues("destination", new Object[]{new ActiveMQQueue("TEST.Q")});
    }

    public void testPredefinedDestinations() throws JMSException {
        Message sent = this.doSend(false);
        SimpleAuthenticationPluginTest.assertEquals((String)"guest", (String)((ActiveMQMessage)sent).getUserID());
        SimpleAuthenticationPluginTest.assertEquals((String)"guest", (String)sent.getStringProperty("JMSXUserID"));
    }

    public void testTempDestinations() throws Exception {
        Connection conn = this.factory.createConnection("guest", "password");
        Session sess = conn.createSession(false, 1);
        String name = "org.apache.activemq:BrokerName=localhost,Type=TempTopic";
        try {
            conn.start();
            TemporaryTopic temp = sess.createTemporaryTopic();
            name = name + ",Destination=" + temp.getTopicName().replaceAll(":", "_");
            SimpleAuthenticationPluginTest.fail((String)"Should have failed creating a temp topic");
        }
        catch (Exception ignore) {
            // empty catch block
        }
        ObjectName objName = new ObjectName(name);
        TopicViewMBean mbean = (TopicViewMBean)this.broker.getManagementContext().newProxyInstance(objName, TopicViewMBean.class, true);
        try {
            System.out.println(mbean.getName());
            SimpleAuthenticationPluginTest.fail((String)"Shouldn't have created a temp topic");
        }
        catch (Exception ignore) {
            // empty catch block
        }
    }
}

