/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.store.jdbc;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.Queue;
import javax.jms.XAConnection;
import javax.jms.XASession;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.apache.activemq.ActiveMQXAConnectionFactory;
import org.apache.activemq.store.jdbc.JDBCCommitExceptionTest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JDBCXACommitExceptionTest
extends JDBCCommitExceptionTest {
    private static final Log LOG = LogFactory.getLog(JDBCXACommitExceptionTest.class);
    private long txGenerator = System.currentTimeMillis();
    protected ActiveMQXAConnectionFactory factory = new ActiveMQXAConnectionFactory("tcp://localhost:61616?jms.prefetchPolicy.all=0&jms.redeliveryPolicy.maximumRedeliveries=10");
    boolean onePhase = true;

    public void testTwoPhaseSqlException() throws Exception {
        this.onePhase = false;
        this.doTestSqlException();
    }

    protected int receiveMessages(int messagesExpected) throws Exception {
        XAConnection connection = this.factory.createXAConnection();
        connection.start();
        XASession session = connection.createXASession();
        this.jdbc.setShouldBreak(true);
        this.receiveMessages(messagesExpected, session, this.onePhase);
        this.jdbc.setShouldBreak(false);
        return this.receiveMessages(messagesExpected, session, this.onePhase);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int receiveMessages(int messagesExpected, XASession session, boolean onePhase) throws Exception {
        int messagesReceived = 0;
        for (int i = 0; i < messagesExpected; ++i) {
            Queue destination = session.createQueue("TEST");
            MessageConsumer consumer = session.createConsumer((Destination)destination);
            XAResource resource = session.getXAResource();
            resource.recover(0x1000000);
            resource.recover(0);
            Xid tid = this.createXid();
            Message message = null;
            try {
                LOG.debug((Object)("Receiving message " + (messagesReceived + 1) + " of " + messagesExpected));
                resource.start(tid, 0);
                message = consumer.receive(2000L);
                LOG.info((Object)("Received : " + message));
                resource.end(tid, 0x4000000);
                if (message == null) continue;
                if (onePhase) {
                    resource.commit(tid, true);
                } else {
                    resource.prepare(tid);
                    resource.commit(tid, false);
                }
                ++messagesReceived;
                continue;
            }
            catch (Exception e) {
                LOG.debug((Object)"Caught exception:", (Throwable)e);
                try {
                    LOG.debug((Object)("Rolling back transaction (just in case, no need to do this as it is implicit in a commit failure) " + tid));
                    resource.rollback(tid);
                }
                catch (XAException ex) {
                    try {
                        LOG.debug((Object)("Caught exception during rollback: " + ex + " forgetting transaction " + tid));
                        resource.forget(tid);
                    }
                    catch (XAException ex1) {
                        LOG.debug((Object)("rollback/forget failed: " + ex1.errorCode));
                    }
                }
                continue;
            }
            finally {
                if (consumer != null) {
                    consumer.close();
                }
            }
        }
        return messagesReceived;
    }

    public Xid createXid() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream os = new DataOutputStream(baos);
        os.writeLong(++this.txGenerator);
        os.close();
        final byte[] bs = baos.toByteArray();
        return new Xid(){

            public int getFormatId() {
                return 86;
            }

            public byte[] getGlobalTransactionId() {
                return bs;
            }

            public byte[] getBranchQualifier() {
                return bs;
            }
        };
    }
}

