/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.store.kahadb.plist;

import java.io.File;
import java.io.IOException;
import java.util.LinkedHashMap;
import org.apache.activemq.store.kahadb.plist.PList;
import org.apache.activemq.store.kahadb.plist.PListEntry;
import org.apache.activemq.store.kahadb.plist.PListStore;
import org.apache.activemq.util.IOHelper;
import org.apache.kahadb.util.ByteSequence;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class PListTest {
    private PListStore store;
    private PList plist;

    @Test
    public void testAddLast() throws Exception {
        int COUNT = 1000;
        LinkedHashMap<String, ByteSequence> map = new LinkedHashMap<String, ByteSequence>();
        for (int i = 0; i < 1000; ++i) {
            String test = new String("test" + i);
            ByteSequence bs = new ByteSequence(test.getBytes());
            map.put(test, bs);
            this.plist.addLast(test, bs);
        }
        Assert.assertEquals((long)this.plist.size(), (long)1000L);
        int count = 0;
        for (ByteSequence bs : map.values()) {
            String origStr = new String(bs.getData(), bs.getOffset(), bs.getLength());
            PListEntry entry = this.plist.get(count);
            String plistString = new String(entry.getByteSequence().getData(), entry.getByteSequence().getOffset(), entry.getByteSequence().getLength());
            Assert.assertEquals((Object)origStr, (Object)plistString);
            ++count;
        }
    }

    @Test
    public void testAddFirst() throws Exception {
        int COUNT = 1000;
        LinkedHashMap<String, ByteSequence> map = new LinkedHashMap<String, ByteSequence>();
        for (int i = 0; i < 1000; ++i) {
            String test = new String("test" + i);
            ByteSequence bs = new ByteSequence(test.getBytes());
            map.put(test, bs);
            this.plist.addFirst(test, bs);
        }
        Assert.assertEquals((long)this.plist.size(), (long)1000L);
        int count = this.plist.size() - 1;
        for (ByteSequence bs : map.values()) {
            String origStr = new String(bs.getData(), bs.getOffset(), bs.getLength());
            PListEntry entry = this.plist.get(count);
            String plistString = new String(entry.getByteSequence().getData(), entry.getByteSequence().getOffset(), entry.getByteSequence().getLength());
            Assert.assertEquals((Object)origStr, (Object)plistString);
            --count;
        }
    }

    @Test
    public void testRemove() throws IOException {
        this.doTestRemove(2000);
    }

    protected void doTestRemove(int COUNT) throws IOException {
        LinkedHashMap<String, ByteSequence> map = new LinkedHashMap<String, ByteSequence>();
        for (int i = 0; i < COUNT; ++i) {
            String test = new String("test" + i);
            ByteSequence bs = new ByteSequence(test.getBytes());
            map.put(test, bs);
            this.plist.addLast(test, bs);
        }
        Assert.assertEquals((long)this.plist.size(), (long)COUNT);
        PListEntry entry = this.plist.getFirst();
        while (entry != null) {
            this.plist.remove(entry.copy());
            entry = this.plist.getFirst();
        }
        Assert.assertEquals((long)0L, (long)this.plist.size());
    }

    @Test
    public void testDestroy() throws Exception {
        this.doTestRemove(1);
        this.plist.destroy();
        Assert.assertEquals((long)0L, (long)this.plist.size());
    }

    @Test
    public void testDestroyNonEmpty() throws Exception {
        int COUNT = 1000;
        LinkedHashMap<String, ByteSequence> map = new LinkedHashMap<String, ByteSequence>();
        for (int i = 0; i < 1000; ++i) {
            String test = new String("test" + i);
            ByteSequence bs = new ByteSequence(test.getBytes());
            map.put(test, bs);
            this.plist.addLast(test, bs);
        }
        this.plist.destroy();
        Assert.assertEquals((long)0L, (long)this.plist.size());
        Assert.assertNull((String)"no first entry", (Object)this.plist.getFirst());
    }

    @Test
    public void testRemoveSecond() throws Exception {
        this.plist.addLast("First", new ByteSequence("A".getBytes()));
        this.plist.addLast("Second", new ByteSequence("B".getBytes()));
        Assert.assertTrue((boolean)this.plist.remove("Second"));
        Assert.assertTrue((boolean)this.plist.remove("First"));
        Assert.assertFalse((boolean)this.plist.remove("doesNotExist"));
    }

    @Test
    public void testRemoveSecondPosition() throws Exception {
        this.plist.addLast("First", new ByteSequence("A".getBytes()));
        this.plist.addLast("Second", new ByteSequence("B".getBytes()));
        Assert.assertTrue((boolean)this.plist.remove(1));
        Assert.assertTrue((boolean)this.plist.remove(0));
        Assert.assertFalse((boolean)this.plist.remove(3));
    }

    @Before
    public void setUp() throws Exception {
        File directory = new File("target/test/PlistDB");
        IOHelper.mkdirs((File)directory);
        IOHelper.deleteChildren((File)directory);
        this.startStore(directory);
    }

    protected void startStore(File directory) throws Exception {
        this.store = new PListStore();
        this.store.setDirectory(directory);
        this.store.start();
        this.plist = this.store.getPList("test");
    }

    @After
    public void tearDown() throws Exception {
        this.store.stop();
    }
}

