/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.test.rollback;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.Session;
import javax.jms.TextMessage;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.EmbeddedBrokerTestSupport;
import org.apache.activemq.RedeliveryPolicy;
import org.apache.activemq.test.rollback.DelegatingTransactionalMessageListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.jms.core.MessageCreator;

public class RollbacksWhileConsumingLargeQueueTest
extends EmbeddedBrokerTestSupport
implements MessageListener {
    private static final transient Log LOG = LogFactory.getLog(RollbacksWhileConsumingLargeQueueTest.class);
    protected int numberOfMessagesOnQueue = 650;
    private Connection connection;
    private AtomicInteger deliveryCounter = new AtomicInteger(0);
    private AtomicInteger ackCounter = new AtomicInteger(0);
    private CountDownLatch latch;
    private Throwable failure;

    public void testWithReciever() throws Throwable {
        this.latch = new CountDownLatch(this.numberOfMessagesOnQueue);
        Session session = this.connection.createSession(true, 0);
        MessageConsumer consumer = session.createConsumer((Destination)this.destination);
        long start = System.currentTimeMillis();
        while (System.currentTimeMillis() - start < 1000000L) {
            if (this.getFailure() != null) {
                throw this.getFailure();
            }
            if (this.ackCounter.get() == this.numberOfMessagesOnQueue) {
                return;
            }
            Message message = consumer.receive(1000L);
            if (message == null) continue;
            try {
                this.onMessage(message);
                session.commit();
            }
            catch (Throwable e) {
                session.rollback();
            }
        }
        RollbacksWhileConsumingLargeQueueTest.fail((String)"Did not receive all the messages.");
    }

    public void testWithMessageListener() throws Throwable {
        this.latch = new CountDownLatch(this.numberOfMessagesOnQueue);
        new DelegatingTransactionalMessageListener(this, this.connection, (Destination)this.destination);
        long start = System.currentTimeMillis();
        while (System.currentTimeMillis() - start < 1000000L) {
            if (this.getFailure() != null) {
                throw this.getFailure();
            }
            if (!this.latch.await(1L, TimeUnit.SECONDS)) continue;
            LOG.debug((Object)("Received: " + this.deliveryCounter.get() + "  message(s)"));
            return;
        }
        RollbacksWhileConsumingLargeQueueTest.fail((String)"Did not receive all the messages.");
    }

    protected ConnectionFactory createConnectionFactory() throws Exception {
        ActiveMQConnectionFactory answer = (ActiveMQConnectionFactory)super.createConnectionFactory();
        RedeliveryPolicy policy = new RedeliveryPolicy();
        policy.setMaximumRedeliveries(3);
        policy.setRedeliveryDelay(0L);
        policy.setInitialRedeliveryDelay(0L);
        policy.setUseExponentialBackOff(false);
        answer.setRedeliveryPolicy(policy);
        return answer;
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.connection = this.createConnection();
        this.connection.start();
        for (int i = 0; i < this.numberOfMessagesOnQueue; ++i) {
            this.template.send(this.createMessageCreator(i));
        }
    }

    protected void tearDown() throws Exception {
        if (this.connection != null) {
            this.connection.close();
        }
        super.tearDown();
    }

    protected MessageCreator createMessageCreator(final int i) {
        return new MessageCreator(){

            public Message createMessage(Session session) throws JMSException {
                TextMessage answer = session.createTextMessage("Message: " + i);
                answer.setIntProperty("Counter", i);
                return answer;
            }
        };
    }

    public void onMessage(Message message) {
        String msgId = null;
        String msgText = null;
        try {
            msgId = message.getJMSMessageID();
            msgText = ((TextMessage)message).getText();
        }
        catch (JMSException e) {
            this.setFailure(e);
        }
        try {
            RollbacksWhileConsumingLargeQueueTest.assertEquals((String)("Message: " + this.ackCounter.get()), (String)msgText);
        }
        catch (Throwable e) {
            this.setFailure(e);
        }
        int value = this.deliveryCounter.incrementAndGet();
        if (value % 2 == 0) {
            LOG.info((Object)("Rolling Back message: " + this.ackCounter.get() + " id: " + msgId + ", content: " + msgText));
            throw new RuntimeException("Dummy exception on message: " + value);
        }
        LOG.info((Object)("Received message: " + this.ackCounter.get() + " id: " + msgId + ", content: " + msgText));
        this.ackCounter.incrementAndGet();
        this.latch.countDown();
    }

    public synchronized Throwable getFailure() {
        return this.failure;
    }

    public synchronized void setFailure(Throwable failure) {
        this.failure = failure;
    }
}

