/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.tcp;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import junit.framework.TestCase;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.TransportConnector;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class SslContextBrokerServiceTest
extends TestCase {
    private ClassPathXmlApplicationContext context;
    private BrokerService broker;
    private TransportConnector connector;

    public void testConfiguration() throws URISyntaxException {
        SslContextBrokerServiceTest.assertNotNull((Object)this.broker);
        SslContextBrokerServiceTest.assertNotNull((Object)this.connector);
        SslContextBrokerServiceTest.assertEquals((Object)new URI("ssl://localhost:61616"), (Object)this.connector.getUri());
        SslContextBrokerServiceTest.assertNotNull((Object)this.broker.getSslContext());
        SslContextBrokerServiceTest.assertFalse((boolean)this.broker.getSslContext().getKeyManagers().isEmpty());
        SslContextBrokerServiceTest.assertFalse((boolean)this.broker.getSslContext().getTrustManagers().isEmpty());
    }

    protected void setUp() throws Exception {
        Thread.currentThread().setContextClassLoader(SslContextBrokerServiceTest.class.getClassLoader());
        this.context = new ClassPathXmlApplicationContext("org/apache/activemq/transport/tcp/activemq-ssl.xml");
        Map beansOfType = this.context.getBeansOfType(BrokerService.class);
        this.broker = (BrokerService)beansOfType.values().iterator().next();
        this.connector = (TransportConnector)this.broker.getTransportConnectors().get(0);
    }

    protected void tearDown() throws Exception {
        this.context.destroy();
    }
}

