/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.tcp;

import java.util.Timer;
import java.util.TimerTask;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.MessageConsumer;
import javax.jms.Session;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.EmbeddedBrokerTestSupport;

public class TcpTransportBindTest
extends EmbeddedBrokerTestSupport {
    final String addr = "tcp://localhost:61617";

    protected void setUp() throws Exception {
        this.bindAddress = "tcp://localhost:61617?transport.reuseAddress=true&transport.soTimeout=1000";
        super.setUp();
    }

    public void testConnect() throws Exception {
        Connection connection = new ActiveMQConnectionFactory("tcp://localhost:61617").createConnection();
        connection.start();
    }

    public void testReceiveThrowsException() throws Exception {
        Connection connection = new ActiveMQConnectionFactory("tcp://localhost:61617").createConnection();
        connection.start();
        Session sess = connection.createSession(false, 1);
        MessageConsumer consumer = sess.createConsumer((Destination)this.createDestination());
        Timer timer = new Timer();
        class StopTask
        extends TimerTask {
            StopTask() {
            }

            public void run() {
                try {
                    TcpTransportBindTest.this.broker.stop();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        timer.schedule((TimerTask)new StopTask(), 1000L);
        try {
            consumer.receive(30000L);
            TcpTransportBindTest.fail((String)"Should have thrown an exception");
        }
        catch (Exception e) {
            // empty catch block
        }
    }
}

