/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.usecases;

import java.net.URI;
import javax.jms.Destination;
import javax.jms.MessageConsumer;
import org.apache.activemq.JmsMultipleBrokersTestSupport;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.network.NetworkConnector;
import org.apache.activemq.util.MessageIdList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AMQ2927Test
extends JmsMultipleBrokersTestSupport {
    private static final Log LOG = LogFactory.getLog(AMQ2927Test.class);
    ActiveMQQueue queue = new ActiveMQQueue("TEST");

    public void setUp() throws Exception {
        super.setAutoFail(true);
        super.setUp();
        BrokerService brokerA = this.createBroker(new URI("broker:(tcp://localhost:61616)/BrokerA?persistent=true&useJmx=false&deleteAllMessagesOnStartup=true"));
        brokerA.setBrokerId("BrokerA");
        BrokerService brokerB = this.createBroker(new URI("broker:(tcp://localhost:61617)/BrokerB?persistent=true&useJmx=false&deleteAllMessagesOnStartup=true"));
        brokerB.setBrokerId("BrokerB");
        NetworkConnector aTOb = this.bridgeBrokers(((JmsMultipleBrokersTestSupport.BrokerItem)this.brokers.get((Object)"BrokerA")).broker, ((JmsMultipleBrokersTestSupport.BrokerItem)this.brokers.get((Object)"BrokerB")).broker, false, 2, true, true);
        aTOb.addStaticallyIncludedDestination((ActiveMQDestination)this.queue);
        NetworkConnector bTOa = this.bridgeBrokers(((JmsMultipleBrokersTestSupport.BrokerItem)this.brokers.get((Object)"BrokerB")).broker, ((JmsMultipleBrokersTestSupport.BrokerItem)this.brokers.get((Object)"BrokerA")).broker, false, 2, true, true);
        bTOa.addStaticallyIncludedDestination((ActiveMQDestination)this.queue);
        this.startAllBrokers();
        this.waitForBridgeFormation();
    }

    public void testRestartSend() throws Exception {
        Thread.sleep(1000L);
        LOG.info((Object)"restarting broker");
        this.restartBroker("BrokerA");
        Thread.sleep(5000L);
        LOG.info((Object)"sending message");
        this.sendMessages("BrokerA", (Destination)this.queue, 1);
        Thread.sleep(3000L);
        LOG.info((Object)"consuming message");
        MessageConsumer consumerA = this.createConsumer("BrokerA", (Destination)this.queue);
        MessageConsumer consumerB = this.createConsumer("BrokerB", (Destination)this.queue);
        Thread.sleep(1000L);
        MessageIdList messagesA = this.getConsumerMessages("BrokerA", consumerA);
        MessageIdList messagesB = this.getConsumerMessages("BrokerB", consumerB);
        LOG.info((Object)("consumerA = " + (Object)((Object)messagesA)));
        LOG.info((Object)("consumerB = " + (Object)((Object)messagesB)));
        messagesA.assertMessagesReceived(0);
        messagesB.assertMessagesReceived(1);
    }

    public void testSendRestart() throws Exception {
        Thread.sleep(1000L);
        LOG.info((Object)"sending message");
        this.sendMessages("BrokerA", (Destination)this.queue, 1);
        Thread.sleep(3000L);
        LOG.info((Object)"restarting broker");
        this.restartBroker("BrokerA");
        Thread.sleep(5000L);
        LOG.info((Object)"consuming message");
        MessageConsumer consumerA = this.createConsumer("BrokerA", (Destination)this.queue);
        MessageConsumer consumerB = this.createConsumer("BrokerB", (Destination)this.queue);
        Thread.sleep(1000L);
        MessageIdList messagesA = this.getConsumerMessages("BrokerA", consumerA);
        MessageIdList messagesB = this.getConsumerMessages("BrokerB", consumerB);
        LOG.info((Object)("consumerA = " + (Object)((Object)messagesA)));
        LOG.info((Object)("consumerB = " + (Object)((Object)messagesB)));
        messagesA.assertMessagesReceived(0);
        messagesB.assertMessagesReceived(1);
    }

    protected void restartBroker(String brokerName) throws Exception {
        this.destroyBroker("BrokerA");
        BrokerService broker = this.createBroker(new URI("broker:(tcp://localhost:61616)/BrokerA?persistent=true&useJmx=false"));
        broker.setBrokerId("BrokerA");
        NetworkConnector aTOb = this.bridgeBrokers(((JmsMultipleBrokersTestSupport.BrokerItem)this.brokers.get((Object)"BrokerA")).broker, ((JmsMultipleBrokersTestSupport.BrokerItem)this.brokers.get((Object)"BrokerB")).broker, false, 2, true, true);
        aTOb.addStaticallyIncludedDestination((ActiveMQDestination)this.queue);
        broker.start();
        broker.waitUntilStarted();
        this.waitForBridgeFormation();
    }
}

