/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.usecases;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import javax.jms.Destination;
import javax.jms.MessageConsumer;
import org.apache.activemq.JmsMultipleBrokersTestSupport;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.region.DestinationInterceptor;
import org.apache.activemq.broker.region.virtual.VirtualDestination;
import org.apache.activemq.broker.region.virtual.VirtualDestinationInterceptor;
import org.apache.activemq.broker.region.virtual.VirtualTopic;
import org.apache.activemq.network.NetworkConnector;
import org.apache.activemq.store.PersistenceAdapter;
import org.apache.activemq.store.kahadb.KahaDBStore;
import org.apache.activemq.util.MessageIdList;

public abstract class AbstractTwoBrokerNetworkConnectorWildcardIncludedDestinationTestSupport
extends JmsMultipleBrokersTestSupport {
    protected static final int MESSAGE_COUNT = 1;
    boolean dynamicOnly = true;
    int networkTTL = 1;
    boolean conduit = true;
    boolean suppressDuplicateQueueSubscriptions = true;
    boolean decreaseNetworkConsumerPriority = true;

    public void testSimpleNWOB() throws Exception {
        this.sendReceive("BrokerA", "local.test", false, "BrokerB", "local.test", false, 1, 0);
        this.sendReceive("BrokerA", "local.test", true, "BrokerB", "local.test", true, 1, 0);
        this.sendReceive("BrokerA", "global.test", false, "BrokerB", "global.test", false, 1, 1);
        this.sendReceive("BrokerA", "global.test", true, "BrokerB", "global.test", true, 1, 1);
    }

    public void testSimpleNWOBWithWildcardSubscriptions() throws Exception {
        this.sendReceive("BrokerA", "local.test.1", false, "BrokerB", "local.test.>", false, 1, 0);
        this.sendReceive("BrokerA", "local.test.2", true, "BrokerB", "local.test.>", true, 1, 0);
        this.sendReceive("BrokerA", "global.test.1", false, "BrokerB", "global.test.>", false, 1, 1);
        this.sendReceive("BrokerA", "global.test.2", true, "BrokerB", "global.test.>", true, 1, 1);
    }

    public void testSimpleNWOBWithVirtualDestinations() throws Exception {
        this.sendReceive("BrokerA", "local.test", true, "BrokerB", "Consumer.a.local.test", false, 1, 0);
        this.sendReceive("BrokerA", "global.test", true, "BrokerB", "Consumer.a.global.test", false, 1, 1);
    }

    public void testSimpleNWOBWithVirtualDestinationsAndWildcardSubscriptions() throws Exception {
        this.sendReceive("BrokerA", "local.test.1", true, "BrokerB", "Consumer.a.local.test.>", false, 1, 0);
        this.sendReceive("BrokerA", "global.test.1", true, "BrokerB", "Consumer.a.global.test.>", false, 1, 1);
    }

    public void sendReceive(String broker1, String dest1, boolean topic1, String broker2, String dest2, boolean topic2, int send, int expected) throws Exception {
        MessageConsumer client = this.createConsumer(broker2, (Destination)this.createDestination(dest2, topic2));
        Thread.sleep(1000L);
        this.sendMessages(broker1, (Destination)this.createDestination(dest1, topic1), send);
        MessageIdList msgs = this.getConsumerMessages(broker2, client);
        msgs.setMaximumDuration(1000L);
        msgs.waitForMessagesToArrive(send);
        AbstractTwoBrokerNetworkConnectorWildcardIncludedDestinationTestSupport.assertEquals((int)expected, (int)msgs.getMessageCount());
        client.close();
        Thread.sleep(500L);
    }

    protected abstract void addIncludedDestination(NetworkConnector var1);

    public void setUp() throws Exception {
        super.setAutoFail(true);
        super.setUp();
        String options = new String("?useJmx=false&deleteAllMessagesOnStartup=true");
        this.createAndConfigureBroker(new URI("broker:(tcp://localhost:61616)/BrokerA" + options));
        this.createAndConfigureBroker(new URI("broker:(tcp://localhost:61617)/BrokerB" + options));
        NetworkConnector nc = this.bridgeBrokers("BrokerA", "BrokerB", this.dynamicOnly, this.networkTTL, this.conduit);
        nc.setDecreaseNetworkConsumerPriority(this.decreaseNetworkConsumerPriority);
        nc.setSuppressDuplicateQueueSubscriptions(this.suppressDuplicateQueueSubscriptions);
        this.addIncludedDestination(nc);
        nc = this.bridgeBrokers("BrokerB", "BrokerA", this.dynamicOnly, this.networkTTL, this.conduit);
        nc.setDecreaseNetworkConsumerPriority(this.decreaseNetworkConsumerPriority);
        nc.setSuppressDuplicateQueueSubscriptions(this.suppressDuplicateQueueSubscriptions);
        this.addIncludedDestination(nc);
        this.startAllBrokers();
    }

    private BrokerService createAndConfigureBroker(URI uri) throws Exception {
        BrokerService broker = this.createBroker(uri);
        this.configurePersistenceAdapter(broker);
        VirtualDestinationInterceptor virtualDestinationInterceptor = new VirtualDestinationInterceptor();
        virtualDestinationInterceptor.setVirtualDestinations(new VirtualDestination[]{new VirtualTopic()});
        DestinationInterceptor[] destinationInterceptors = new DestinationInterceptor[]{virtualDestinationInterceptor};
        broker.setDestinationInterceptors(destinationInterceptors);
        return broker;
    }

    protected void configurePersistenceAdapter(BrokerService broker) throws IOException {
        File dataFileDir = new File("target/test-amq-data/kahadb/" + broker.getBrokerName());
        KahaDBStore kaha = new KahaDBStore();
        kaha.setDirectory(dataFileDir);
        broker.setPersistenceAdapter((PersistenceAdapter)kaha);
    }
}

