/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.usecases;

import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.TestSupport;
import org.apache.activemq.broker.BrokerFactory;
import org.apache.activemq.broker.BrokerPlugin;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.security.AuthorizationMap;
import org.apache.activemq.security.AuthorizationPlugin;
import org.apache.activemq.security.SimpleAuthorizationMap;

public class AuthorizationFromAdminViewTest
extends TestSupport {
    private BrokerService broker;

    protected ActiveMQConnectionFactory createConnectionFactory() throws Exception {
        return new ActiveMQConnectionFactory("vm://" + this.getName());
    }

    protected void setUp() throws Exception {
        this.createBroker();
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.destroyBroker();
    }

    private void createBroker() throws Exception {
        this.broker = BrokerFactory.createBroker((String)"broker:(vm://localhost)");
        this.broker.setPersistent(false);
        this.broker.setBrokerName(this.getName());
        AuthorizationPlugin plugin = new AuthorizationPlugin();
        plugin.setMap((AuthorizationMap)new SimpleAuthorizationMap());
        BrokerPlugin[] plugins = new BrokerPlugin[]{plugin};
        this.broker.setPlugins(plugins);
        this.broker.start();
    }

    private void destroyBroker() throws Exception {
        if (this.broker != null) {
            this.broker.stop();
        }
    }

    public void testAuthorizationFromAdminView() throws Exception {
        this.broker.getAdminView().addQueue(this.getDestinationString());
    }
}

