/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.usecases;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicSubscriber;
import junit.framework.Test;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.ActiveMQPrefetchPolicy;
import org.apache.activemq.TestSupport;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.region.policy.PolicyEntry;
import org.apache.activemq.broker.region.policy.PolicyMap;
import org.apache.activemq.util.MessageIdList;
import org.apache.activemq.util.Wait;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ConcurrentProducerDurableConsumerTest
extends TestSupport {
    private static final Log LOG = LogFactory.getLog(ConcurrentProducerDurableConsumerTest.class);
    private int consumerCount = 5;
    BrokerService broker;
    protected List<Connection> connections = Collections.synchronizedList(new ArrayList());
    protected Map<MessageConsumer, TimedMessageListener> consumers = new HashMap<MessageConsumer, TimedMessageListener>();
    protected MessageIdList allMessagesList = new MessageIdList();
    private int messageSize = 1024;

    public void initCombosForTestSendRateWithActivatingConsumers() throws Exception {
        this.addCombinationValues("defaultPersistenceAdapter", new Object[]{TestSupport.PersistenceAdapterChoice.KahaDB, TestSupport.PersistenceAdapterChoice.MEM});
    }

    public void testSendRateWithActivatingConsumers() throws Exception {
        Destination destination = this.createDestination();
        ActiveMQConnectionFactory factory = this.createConnectionFactory();
        this.startInactiveConsumers((ConnectionFactory)factory, destination);
        Connection connection = factory.createConnection();
        Session session = connection.createSession(false, 1);
        MessageProducer producer = this.createMessageProducer(session, destination);
        double[] inactiveConsumerStats = this.produceMessages(destination, 500, 10, session, producer, null);
        LOG.info((Object)("With inactive consumers: ave: " + inactiveConsumerStats[1] + ", max: " + inactiveConsumerStats[0] + ", multiplier: " + inactiveConsumerStats[0] / inactiveConsumerStats[1]));
        int consumersToActivate = 5;
        final Object addConsumerSignal = new Object();
        Executors.newCachedThreadPool(new ThreadFactory(){

            public Thread newThread(Runnable r) {
                return new Thread(r, "ActivateConsumer" + this);
            }
        }).execute(new Runnable((ConnectionFactory)factory, destination){
            final /* synthetic */ ConnectionFactory val$factory;
            final /* synthetic */ Destination val$destination;
            {
                this.val$factory = connectionFactory;
                this.val$destination = destination;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    TopicSubscriber consumer = null;
                    for (int i = 0; i < 5; ++i) {
                        LOG.info((Object)"Waiting for add signal from producer...");
                        Object object = addConsumerSignal;
                        synchronized (object) {
                            addConsumerSignal.wait(1800000L);
                        }
                        TimedMessageListener listener = new TimedMessageListener();
                        consumer = ConcurrentProducerDurableConsumerTest.this.createDurableSubscriber(this.val$factory.createConnection(), this.val$destination, "consumer" + (i + 1));
                        LOG.info((Object)("Created consumer " + consumer));
                        consumer.setMessageListener((MessageListener)listener);
                        ConcurrentProducerDurableConsumerTest.this.consumers.put((MessageConsumer)consumer, listener);
                    }
                }
                catch (Exception e) {
                    LOG.error((Object)"failed to start consumer", (Throwable)e);
                }
            }
        });
        double[] statsWithActive = this.produceMessages(destination, 300, 10, session, producer, addConsumerSignal);
        LOG.info((Object)(" with concurrent activate, ave: " + statsWithActive[1] + ", max: " + statsWithActive[0] + ", multiplier: " + statsWithActive[0] / statsWithActive[1]));
        while (this.consumers.size() < 5) {
            TimeUnit.SECONDS.sleep(2L);
        }
        long timeToFirstAccumulator = 0L;
        for (TimedMessageListener listener : this.consumers.values()) {
            long time = listener.getFirstReceipt();
            timeToFirstAccumulator += time;
            LOG.info((Object)("Time to first " + time));
        }
        LOG.info((Object)("Ave time to first message =" + timeToFirstAccumulator / (long)this.consumers.size()));
        for (TimedMessageListener listener : this.consumers.values()) {
            LOG.info((Object)("Ave batch receipt time: " + listener.waitForReceivedLimit(5000L) + " max receipt: " + listener.maxReceiptTime));
        }
        LOG.info((Object)("Ave send time with active: " + statsWithActive[1] + " as multiplier of ave with none active: " + inactiveConsumerStats[1] + ", multiplier=" + statsWithActive[1] / inactiveConsumerStats[1]));
        ConcurrentProducerDurableConsumerTest.assertTrue((String)("Ave send time with active: " + statsWithActive[1] + " within reasonable multpler of ave with none active: " + inactiveConsumerStats[1] + ", multiplier " + statsWithActive[1] / inactiveConsumerStats[1]), (statsWithActive[1] < 15.0 * inactiveConsumerStats[1] ? 1 : 0) != 0);
    }

    public void x_initCombosForTestSendWithInactiveAndActiveConsumers() throws Exception {
        this.addCombinationValues("defaultPersistenceAdapter", new Object[]{TestSupport.PersistenceAdapterChoice.KahaDB, TestSupport.PersistenceAdapterChoice.JDBC});
    }

    public void x_testSendWithInactiveAndActiveConsumers() throws Exception {
        Destination destination = this.createDestination();
        ActiveMQConnectionFactory factory = this.createConnectionFactory();
        this.startInactiveConsumers((ConnectionFactory)factory, destination);
        Connection connection = factory.createConnection();
        Session session = connection.createSession(false, 1);
        MessageProducer producer = session.createProducer(destination);
        producer.setDeliveryMode(2);
        int toSend = 100;
        int numIterations = 5;
        double[] noConsumerStats = this.produceMessages(destination, 100, 5, session, producer, null);
        this.startConsumers((ConnectionFactory)factory, destination);
        LOG.info((Object)"Activated consumer");
        double[] withConsumerStats = this.produceMessages(destination, 100, 5, session, producer, null);
        LOG.info((Object)("With consumer: " + withConsumerStats[1] + " , with noConsumer: " + noConsumerStats[1] + ", multiplier: " + withConsumerStats[1] / noConsumerStats[1]));
        int reasonableMultiplier = 15;
        ConcurrentProducerDurableConsumerTest.assertTrue((String)("max X times as slow with consumer: " + withConsumerStats[1] + ", with no Consumer: " + noConsumerStats[1] + ", multiplier: " + withConsumerStats[1] / noConsumerStats[1]), (withConsumerStats[1] < noConsumerStats[1] * 15.0 ? 1 : 0) != 0);
        final int toReceive = 500 * this.consumerCount * 2;
        Wait.waitFor(new Wait.Condition(){

            public boolean isSatisified() throws Exception {
                LOG.info((Object)("count: " + ConcurrentProducerDurableConsumerTest.this.allMessagesList.getMessageCount()));
                return toReceive == ConcurrentProducerDurableConsumerTest.this.allMessagesList.getMessageCount();
            }
        }, 60000L);
        ConcurrentProducerDurableConsumerTest.assertEquals((String)"got all messages", (int)toReceive, (int)this.allMessagesList.getMessageCount());
    }

    private MessageProducer createMessageProducer(Session session, Destination destination) throws JMSException {
        MessageProducer producer = session.createProducer(destination);
        producer.setDeliveryMode(2);
        return producer;
    }

    private void startInactiveConsumers(ConnectionFactory factory, Destination destination) throws Exception {
        this.startConsumers(factory, destination);
        for (Connection connection : this.connections) {
            connection.close();
        }
        this.connections.clear();
        this.consumers.clear();
    }

    protected void startConsumers(ConnectionFactory factory, Destination dest) throws Exception {
        for (int i = 0; i < this.consumerCount; ++i) {
            TimedMessageListener list = new TimedMessageListener();
            TopicSubscriber consumer = this.createDurableSubscriber(factory.createConnection(), dest, "consumer" + (i + 1));
            consumer.setMessageListener((MessageListener)list);
            this.consumers.put((MessageConsumer)consumer, list);
        }
    }

    protected TopicSubscriber createDurableSubscriber(Connection conn, Destination dest, String name) throws Exception {
        conn.setClientID(name);
        this.connections.add(conn);
        conn.start();
        Session sess = conn.createSession(false, 1);
        TopicSubscriber consumer = sess.createDurableSubscriber((Topic)dest, name);
        return consumer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private double[] produceMessages(Destination destination, int toSend, int numIterations, Session session, MessageProducer producer, Object addConsumerSignal) throws Exception {
        long count = 0L;
        double batchMax = 0.0;
        double max = 0.0;
        double sum = 0.0;
        for (int i = 0; i < numIterations; ++i) {
            long start = System.currentTimeMillis();
            for (int j = 0; j < toSend; ++j) {
                long singleSendstart = System.currentTimeMillis();
                TextMessage msg = this.createTextMessage(session, "" + j);
                producer.send((Message)msg);
                max = Math.max(max, (double)(System.currentTimeMillis() - singleSendstart));
                if (++count % 500L == 0L && addConsumerSignal != null) {
                    Object object = addConsumerSignal;
                    synchronized (object) {
                        addConsumerSignal.notifyAll();
                        LOG.info((Object)"Signalled add consumer");
                    }
                }
                if (count % 5000L != 0L) continue;
                LOG.info((Object)("Sent " + count + ", singleSendMax:" + max));
            }
            long duration = System.currentTimeMillis() - start;
            batchMax = Math.max(batchMax, (double)duration);
            sum += (double)duration;
            LOG.info((Object)("Iteration " + i + ", sent " + toSend + ", time: " + duration + ", batchMax:" + batchMax + ", singleSendMax:" + max));
        }
        LOG.info((Object)("Sent: " + toSend * numIterations + ", batchMax: " + batchMax + " singleSendMax: " + max));
        return new double[]{batchMax, sum / (double)numIterations};
    }

    protected TextMessage createTextMessage(Session session, String initText) throws Exception {
        TextMessage msg = session.createTextMessage();
        if (initText.length() < this.messageSize) {
            char[] data = new char[this.messageSize - initText.length()];
            Arrays.fill(data, '*');
            String str = new String(data);
            msg.setText(initText + str);
        } else {
            msg.setText(initText);
        }
        return msg;
    }

    protected void setUp() throws Exception {
        this.topic = true;
        super.setUp();
        this.broker = this.createBroker();
        this.broker.start();
    }

    protected void tearDown() throws Exception {
        for (Connection conn : this.connections) {
            try {
                conn.close();
            }
            catch (Throwable throwable) {}
        }
        this.broker.stop();
        this.allMessagesList.flushMessages();
        this.consumers.clear();
        super.tearDown();
    }

    protected BrokerService createBroker() throws Exception {
        BrokerService brokerService = new BrokerService();
        brokerService.setEnableStatistics(false);
        brokerService.addConnector("tcp://0.0.0.0:61616");
        brokerService.setDeleteAllMessagesOnStartup(true);
        PolicyEntry policy = new PolicyEntry();
        policy.setPrioritizedMessages(true);
        policy.setMaxPageSize(500);
        PolicyMap policyMap = new PolicyMap();
        policyMap.setDefaultEntry(policy);
        brokerService.setDestinationPolicy(policyMap);
        this.setDefaultPersistenceAdapter(brokerService);
        return brokerService;
    }

    protected ActiveMQConnectionFactory createConnectionFactory() throws Exception {
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory("tcp://localhost:61616");
        ActiveMQPrefetchPolicy prefetchPolicy = new ActiveMQPrefetchPolicy();
        prefetchPolicy.setAll(1);
        factory.setPrefetchPolicy(prefetchPolicy);
        factory.setDispatchAsync(true);
        return factory;
    }

    public static Test suite() {
        return ConcurrentProducerDurableConsumerTest.suite(ConcurrentProducerDurableConsumerTest.class);
    }

    class TimedMessageListener
    implements MessageListener {
        final int batchSize = 1000;
        CountDownLatch firstReceiptLatch = new CountDownLatch(1);
        long mark = System.currentTimeMillis();
        long firstReceipt = 0L;
        long receiptAccumulator = 0L;
        long batchReceiptAccumulator = 0L;
        long maxReceiptTime = 0L;
        AtomicLong count = new AtomicLong(0L);

        TimedMessageListener() {
        }

        public void onMessage(Message message) {
            long current = System.currentTimeMillis();
            long duration = current - this.mark;
            this.receiptAccumulator += duration;
            ConcurrentProducerDurableConsumerTest.this.allMessagesList.onMessage(message);
            if (this.count.incrementAndGet() == 1L) {
                this.firstReceipt = duration;
                this.firstReceiptLatch.countDown();
                LOG.info((Object)("First receipt in " + this.firstReceipt + "ms"));
            } else if (this.count.get() % 1000L == 0L) {
                LOG.info((Object)("Consumed 1000 in " + this.batchReceiptAccumulator + "ms"));
                this.batchReceiptAccumulator = 0L;
            }
            this.maxReceiptTime = Math.max(this.maxReceiptTime, duration);
            this.receiptAccumulator += duration;
            this.batchReceiptAccumulator += duration;
            this.mark = current;
        }

        long getMessageCount() {
            return this.count.get();
        }

        long getFirstReceipt() throws Exception {
            this.firstReceiptLatch.await(30L, TimeUnit.SECONDS);
            return this.firstReceipt;
        }

        public long waitForReceivedLimit(long limit) throws Exception {
            long expiry = System.currentTimeMillis() + 1800000L;
            while (this.count.get() < limit) {
                if (System.currentTimeMillis() > expiry) {
                    throw new RuntimeException("Expired waiting for X messages, " + limit);
                }
                TimeUnit.SECONDS.sleep(2L);
            }
            return this.receiptAccumulator / (limit / 1000L);
        }
    }
}

