/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.usecases;

import java.lang.management.ManagementFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.Topic;
import javax.jms.TopicSubscriber;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import junit.framework.Test;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.TestSupport;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.command.ActiveMQTopic;
import org.apache.activemq.store.jdbc.JDBCPersistenceAdapter;
import org.apache.activemq.util.Wait;

public class DurableSubscriptionSelectorTest
extends TestSupport {
    MBeanServer mbs;
    BrokerService broker = null;
    ActiveMQTopic topic;
    ActiveMQConnection consumerConnection = null;
    ActiveMQConnection producerConnection = null;
    Session producerSession;
    MessageProducer producer;
    private int received = 0;

    public static Test suite() {
        return DurableSubscriptionSelectorTest.suite(DurableSubscriptionSelectorTest.class);
    }

    public void initCombosForTestSubscription() throws Exception {
        this.addCombinationValues("defaultPersistenceAdapter", (Object[])TestSupport.PersistenceAdapterChoice.values());
    }

    public void testSubscription() throws Exception {
        this.openConsumer();
        for (int i = 0; i < 4000; ++i) {
            this.sendMessage(false);
        }
        Thread.sleep(1000L);
        DurableSubscriptionSelectorTest.assertEquals((String)"Invalid message received.", (int)0, (int)this.received);
        this.closeProducer();
        this.closeConsumer();
        this.stopBroker();
        this.startBroker(false);
        this.openConsumer();
        this.sendMessage(true);
        Wait.waitFor(new Wait.Condition(){

            public boolean isSatisified() {
                return DurableSubscriptionSelectorTest.this.received >= 1;
            }
        }, 10000L);
        DurableSubscriptionSelectorTest.assertEquals((String)"Message is not recieved.", (int)1, (int)this.received);
        this.sendMessage(true);
        Thread.sleep(100L);
        DurableSubscriptionSelectorTest.assertEquals((String)"Message is not recieved.", (int)2, (int)this.received);
    }

    private void openConsumer() throws Exception {
        this.consumerConnection = (ActiveMQConnection)this.createConnection();
        this.consumerConnection.setClientID("cliID");
        this.consumerConnection.start();
        Session session = this.consumerConnection.createSession(false, 1);
        TopicSubscriber subscriber = session.createDurableSubscriber((Topic)this.topic, "subName", "filter=true", false);
        subscriber.setMessageListener(new MessageListener(){

            public void onMessage(Message message) {
                DurableSubscriptionSelectorTest.this.received++;
            }
        });
    }

    private void closeConsumer() throws JMSException {
        if (this.consumerConnection != null) {
            this.consumerConnection.close();
        }
        this.consumerConnection = null;
    }

    private void sendMessage(boolean filter) throws Exception {
        if (this.producerConnection == null) {
            this.producerConnection = (ActiveMQConnection)this.createConnection();
            this.producerConnection.start();
            this.producerSession = this.producerConnection.createSession(false, 1);
            this.producer = this.producerSession.createProducer((Destination)this.topic);
        }
        Message message = this.producerSession.createMessage();
        message.setBooleanProperty("filter", filter);
        this.producer.send(message);
    }

    private void closeProducer() throws JMSException {
        if (this.producerConnection != null) {
            this.producerConnection.close();
        }
        this.producerConnection = null;
    }

    private int getPendingQueueSize() throws Exception {
        ObjectName[] subs;
        for (ObjectName sub : subs = this.broker.getAdminView().getDurableTopicSubscribers()) {
            if (!"cliID".equals(this.mbs.getAttribute(sub, "ClientId"))) continue;
            Integer size = (Integer)this.mbs.getAttribute(sub, "PendingQueueSize");
            return size != null ? size : 0;
        }
        DurableSubscriptionSelectorTest.assertTrue((boolean)false);
        return -1;
    }

    private void startBroker(boolean deleteMessages) throws Exception {
        this.broker = new BrokerService();
        this.broker.setBrokerName("test-broker");
        if (deleteMessages) {
            this.broker.setDeleteAllMessagesOnStartup(true);
        }
        this.setDefaultPersistenceAdapter(this.broker);
        if (this.broker.getPersistenceAdapter() instanceof JDBCPersistenceAdapter) {
            ((JDBCPersistenceAdapter)this.broker.getPersistenceAdapter()).setMaxRows(5000);
        }
        this.broker.start();
    }

    private void stopBroker() throws Exception {
        if (this.broker != null) {
            this.broker.stop();
        }
        this.broker = null;
    }

    protected ActiveMQConnectionFactory createConnectionFactory() throws Exception {
        return new ActiveMQConnectionFactory("vm://test-broker?jms.watchTopicAdvisories=false&waitForStart=5000&create=false");
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.startBroker(true);
        this.topic = (ActiveMQTopic)this.createDestination();
        this.mbs = ManagementFactory.getPlatformMBeanServer();
    }

    protected void tearDown() throws Exception {
        this.stopBroker();
        super.tearDown();
    }
}

