/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.usecases;

import java.io.File;
import java.util.List;
import javax.jms.Connection;
import javax.jms.Session;
import javax.jms.Topic;
import javax.management.InstanceNotFoundException;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.TestSupport;
import org.apache.activemq.broker.BrokerFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.ConnectionContext;
import org.apache.activemq.broker.jmx.DurableSubscriptionViewMBean;
import org.apache.activemq.broker.region.Destination;
import org.apache.activemq.broker.region.DurableTopicSubscription;
import org.apache.activemq.broker.region.Subscription;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQTopic;
import org.apache.activemq.command.RemoveSubscriptionInfo;
import org.apache.activemq.store.PersistenceAdapter;
import org.apache.activemq.store.kahadb.KahaDBPersistenceAdapter;

public class DurableSubscriptionUnsubscribeTest
extends TestSupport {
    BrokerService broker = null;
    Connection connection = null;
    ActiveMQTopic topic;

    public void testJMXSubscriptionUnsubscribe() throws Exception {
        this.doJMXUnsubscribe(false);
    }

    public void testJMXSubscriptionUnsubscribeWithRestart() throws Exception {
        this.doJMXUnsubscribe(true);
    }

    public void testConnectionSubscriptionUnsubscribe() throws Exception {
        this.doConnectionUnsubscribe(false);
    }

    public void testConnectionSubscriptionUnsubscribeWithRestart() throws Exception {
        this.doConnectionUnsubscribe(true);
    }

    public void testDirectSubscriptionUnsubscribe() throws Exception {
        this.doDirectUnsubscribe(false);
    }

    public void testDirectubscriptionUnsubscribeWithRestart() throws Exception {
        this.doDirectUnsubscribe(true);
    }

    public void doJMXUnsubscribe(boolean restart) throws Exception {
        this.createSubscriptions();
        Thread.sleep(1000L);
        this.assertCount(100, 0);
        if (restart) {
            this.restartBroker();
            this.assertCount(100, 0);
        }
        ObjectName[] subs = this.broker.getAdminView().getInactiveDurableTopicSubscribers();
        for (int i = 0; i < subs.length; ++i) {
            ObjectName subName = subs[i];
            DurableSubscriptionViewMBean sub = (DurableSubscriptionViewMBean)this.broker.getManagementContext().newProxyInstance(subName, DurableSubscriptionViewMBean.class, true);
            sub.destroy();
            if (i % 20 != 0) continue;
            Thread.sleep(1000L);
            this.assertCount(100 - i - 1, 0);
        }
        Thread.sleep(1000L);
        this.assertCount(0, 0);
        if (restart) {
            this.restartBroker();
            this.assertCount(0, 0);
        }
    }

    public void doConnectionUnsubscribe(boolean restart) throws Exception {
        this.createSubscriptions();
        Thread.sleep(1000L);
        this.assertCount(100, 0);
        Session session = this.connection.createSession(false, 1);
        session.createDurableSubscriber((Topic)this.topic, "SubsId1");
        Thread.sleep(1000L);
        this.assertCount(100, 1);
        Session session2 = this.connection.createSession(false, 1);
        session2.createDurableSubscriber((Topic)this.topic, "SubsId2");
        Thread.sleep(1000L);
        this.assertCount(100, 2);
        session.close();
        Thread.sleep(1000L);
        this.assertCount(100, 1);
        session2.close();
        Thread.sleep(1000L);
        this.assertCount(100, 0);
        if (restart) {
            this.restartBroker();
            this.assertCount(100, 0);
        }
        for (int i = 0; i < 100; ++i) {
            session = this.connection.createSession(false, 1);
            session.unsubscribe("SubsId" + i);
            session.close();
            if (i % 20 != 0) continue;
            Thread.sleep(1000L);
            this.assertCount(100 - i - 1, 0);
        }
        Thread.sleep(1000L);
        this.assertCount(0, 0);
        if (restart) {
            this.restartBroker();
            this.assertCount(0, 0);
        }
    }

    public void doDirectUnsubscribe(boolean restart) throws Exception {
        this.createSubscriptions();
        Thread.sleep(1000L);
        this.assertCount(100, 0);
        if (restart) {
            this.restartBroker();
            this.assertCount(100, 0);
        }
        for (int i = 0; i < 100; ++i) {
            RemoveSubscriptionInfo info = new RemoveSubscriptionInfo();
            info.setClientId(this.getName());
            info.setSubscriptionName("SubsId" + i);
            ConnectionContext context = new ConnectionContext();
            context.setBroker(this.broker.getRegionBroker());
            context.setClientId(this.getName());
            this.broker.getRegionBroker().removeSubscription(context, info);
            if (i % 20 != 0) continue;
            this.assertCount(100 - i - 1, 0);
        }
        this.assertCount(0, 0);
        if (restart) {
            this.restartBroker();
            this.assertCount(0, 0);
        }
    }

    private void createSubscriptions() throws Exception {
        for (int i = 0; i < 100; ++i) {
            Session session = this.connection.createSession(false, 1);
            session.createDurableSubscriber((Topic)this.topic, "SubsId" + i);
            session.close();
        }
    }

    private void assertCount(int all, int active) throws Exception {
        int inactive = all - active;
        Destination destination = this.broker.getDestination((ActiveMQDestination)this.topic);
        List subs = destination.getConsumers();
        int cActive = 0;
        int cInactive = 0;
        for (Subscription sub : subs) {
            if (!(sub instanceof DurableTopicSubscription)) continue;
            DurableTopicSubscription durable = (DurableTopicSubscription)sub;
            if (durable.isActive()) {
                ++cActive;
                continue;
            }
            ++cInactive;
        }
        DurableSubscriptionUnsubscribeTest.assertEquals((int)active, (int)cActive);
        DurableSubscriptionUnsubscribeTest.assertEquals((int)inactive, (int)cInactive);
        ObjectName[] subscriptions = this.broker.getAdminView().getDurableTopicSubscribers();
        DurableSubscriptionUnsubscribeTest.assertEquals((int)active, (int)subscriptions.length);
        subscriptions = this.broker.getAdminView().getInactiveDurableTopicSubscribers();
        DurableSubscriptionUnsubscribeTest.assertEquals((int)inactive, (int)subscriptions.length);
        if (all == 0) {
            DurableSubscriptionUnsubscribeTest.assertEquals((int)0, (int)this.countMBean());
        }
    }

    private int countMBean() throws MalformedObjectNameException, InstanceNotFoundException {
        int count = 0;
        for (int i = 0; i < 100; ++i) {
            String name = "org.apache.activemq:BrokerName=" + this.getName() + ",Type=Subscription,active=false,name=" + this.getName() + "_SubsId" + i;
            ObjectName sub = new ObjectName(name);
            try {
                this.broker.getManagementContext().getObjectInstance(sub);
                ++count;
                continue;
            }
            catch (InstanceNotFoundException ignore) {
                // empty catch block
            }
        }
        return count;
    }

    private void startBroker(boolean deleteMessages) throws Exception {
        this.broker = BrokerFactory.createBroker((String)("broker:(vm://" + this.getName() + ")"));
        this.broker.setUseJmx(true);
        this.broker.setBrokerName(this.getName());
        this.broker.setPersistent(true);
        KahaDBPersistenceAdapter persistenceAdapter = new KahaDBPersistenceAdapter();
        persistenceAdapter.setDirectory(new File("activemq-data/" + this.getName()));
        this.broker.setPersistenceAdapter((PersistenceAdapter)persistenceAdapter);
        if (deleteMessages) {
            this.broker.setDeleteAllMessagesOnStartup(true);
        }
        this.broker.setKeepDurableSubsActive(true);
        this.broker.start();
        this.broker.waitUntilStarted();
        this.connection = this.createConnection();
    }

    private void stopBroker() throws Exception {
        if (this.connection != null) {
            this.connection.close();
        }
        this.connection = null;
        if (this.broker != null) {
            this.broker.stop();
            this.broker.waitUntilStopped();
        }
        this.broker = null;
    }

    private void restartBroker() throws Exception {
        this.stopBroker();
        this.startBroker(false);
    }

    protected ActiveMQConnectionFactory createConnectionFactory() throws Exception {
        return new ActiveMQConnectionFactory("vm://" + this.getName() + "?waitForStart=5000&create=false");
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.topic = (ActiveMQTopic)this.createDestination();
        this.startBroker(true);
    }

    protected void tearDown() throws Exception {
        this.stopBroker();
        super.tearDown();
    }

    protected Connection createConnection() throws Exception {
        Connection rc = super.createConnection();
        rc.setClientID(this.getName());
        rc.start();
        return rc;
    }
}

