/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.usecases;

import java.net.URI;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.activemq.JmsMultipleBrokersTestSupport;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.network.DiscoveryNetworkConnector;
import org.apache.activemq.network.NetworkConnector;
import org.apache.activemq.util.SocketProxy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetworkAsyncStartTest
extends JmsMultipleBrokersTestSupport {
    private static final Logger LOG = LoggerFactory.getLogger(NetworkAsyncStartTest.class);
    private String brokerBUri = "tcp://localhost:61617";
    private String brokerCUri = "tcp://localhost:61618";
    int bridgeCount = 0;

    public void testAsyncNetworkStartup() throws Exception {
        BrokerService brokerA = ((JmsMultipleBrokersTestSupport.BrokerItem)this.brokers.get((Object)"BrokerA")).broker;
        this.bridgeBroker(brokerA, this.brokerBUri);
        this.bridgeBroker(brokerA, this.brokerCUri);
        LOG.info("starting A, no blocking on failed network connectors");
        brokerA.start();
        LOG.info("starting C transport connector");
        BrokerService brokerC = ((JmsMultipleBrokersTestSupport.BrokerItem)this.brokers.get((Object)"BrokerC")).broker;
        brokerC.addConnector(this.brokerCUri);
        brokerC.start();
        NetworkAsyncStartTest.assertTrue((String)"got bridge to C", (boolean)this.waitForBridgeFormation(brokerA, 1, 1));
        LOG.info("Got bridge A->C");
        LOG.info("starting B transport connector");
        BrokerService brokerB = ((JmsMultipleBrokersTestSupport.BrokerItem)this.brokers.get((Object)"BrokerB")).broker;
        brokerB.addConnector(this.brokerBUri);
        brokerC.start();
        NetworkAsyncStartTest.assertTrue((String)"got bridge to B", (boolean)this.waitForBridgeFormation(brokerA, 1, 0));
        NetworkAsyncStartTest.assertTrue((String)"got bridge to B&C", (boolean)this.waitForBridgeFormation(brokerA, 1, 1));
    }

    public void testAsyncNetworkStartupWithSlowConnectionCreation() throws Exception {
        final BrokerService brokerA = ((JmsMultipleBrokersTestSupport.BrokerItem)this.brokers.get((Object)"BrokerA")).broker;
        SocketProxy proxyToB = new SocketProxy();
        proxyToB.setPauseAtStart(true);
        proxyToB.setAcceptBacklog(1);
        proxyToB.setTarget(new URI(this.brokerBUri));
        proxyToB.open();
        this.bridgeBroker(brokerA, proxyToB.getUrl().toString());
        this.bridgeBroker(brokerA, proxyToB.getUrl().toString());
        this.bridgeBroker(brokerA, proxyToB.getUrl().toString());
        this.bridgeBroker(brokerA, proxyToB.getUrl().toString());
        this.bridgeBroker(brokerA, proxyToB.getUrl().toString());
        this.bridgeBroker(brokerA, proxyToB.getUrl().toString());
        this.bridgeBroker(brokerA, proxyToB.getUrl().toString());
        this.bridgeBroker(brokerA, this.brokerCUri);
        ExecutorService e = Executors.newCachedThreadPool();
        e.execute(new Runnable(){

            public void run() {
                LOG.info("starting A");
                try {
                    brokerA.setNetworkConnectorStartAsync(true);
                    brokerA.start();
                }
                catch (Exception e) {
                    LOG.error("start failed", (Throwable)e);
                }
            }
        });
        LOG.info("starting transport connector on C");
        BrokerService brokerC = ((JmsMultipleBrokersTestSupport.BrokerItem)this.brokers.get((Object)"BrokerC")).broker;
        brokerC.addConnector(this.brokerCUri);
        brokerC.start();
        long maxWaitMillis = 20000L;
        NetworkAsyncStartTest.assertTrue((String)"got bridge to C in 10 seconds", (boolean)this.waitForBridgeFormation(brokerA, 1, 7, 20000L));
    }

    private void bridgeBroker(BrokerService localBroker, String remoteURI) throws Exception {
        String uri = "static:(" + remoteURI + ")";
        DiscoveryNetworkConnector connector = new DiscoveryNetworkConnector(new URI(uri));
        connector.setName("bridge-" + this.bridgeCount++);
        localBroker.addNetworkConnector((NetworkConnector)connector);
    }

    public void setUp() throws Exception {
        super.setAutoFail(true);
        super.setUp();
        this.createBroker(new URI("broker:()BrokerA?persistent=false&useJmx=false"));
        this.createBroker(new URI("broker:()BrokerB?persistent=false&useJmx=false"));
        this.createBroker(new URI("broker:()BrokerC?persistent=false&useJmx=false"));
    }
}

