/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.usecases;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.jms.Topic;
import junit.framework.Assert;
import junit.framework.Test;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.CombinationTestSupport;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.region.policy.DispatchPolicy;
import org.apache.activemq.broker.region.policy.PolicyEntry;
import org.apache.activemq.broker.region.policy.PolicyMap;
import org.apache.activemq.broker.region.policy.PriorityNetworkDispatchPolicy;
import org.apache.activemq.broker.region.policy.SimpleDispatchPolicy;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQTopic;
import org.apache.activemq.network.NetworkConnector;
import org.apache.activemq.util.Wait;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class NoDuplicateOnTopicNetworkTest
extends CombinationTestSupport {
    private static final Log LOG = LogFactory.getLog(NoDuplicateOnTopicNetworkTest.class);
    private static final String MULTICAST_DEFAULT = "multicast://default";
    private static final String BROKER_1 = "tcp://localhost:61626";
    private static final String BROKER_2 = "tcp://localhost:61636";
    private static final String BROKER_3 = "tcp://localhost:61646";
    private static final String TOPIC_NAME = "broadcast";
    private BrokerService broker1;
    private BrokerService broker2;
    private BrokerService broker3;
    public boolean suppressDuplicateTopicSubs = false;
    public DispatchPolicy dispatchPolicy = new SimpleDispatchPolicy();
    private boolean dynamicOnly = false;
    private int ttl = 3;

    protected void setUp() throws Exception {
        super.setUp();
        this.broker3 = this.createAndStartBroker("broker3", BROKER_3);
        Thread.sleep(3000L);
        this.broker2 = this.createAndStartBroker("broker2", BROKER_2);
        Thread.sleep(3000L);
        this.broker1 = this.createAndStartBroker("broker1", BROKER_1);
        Thread.sleep(1000L);
        this.waitForBridgeFormation();
    }

    public static Test suite() {
        return NoDuplicateOnTopicNetworkTest.suite(NoDuplicateOnTopicNetworkTest.class);
    }

    protected void waitForBridgeFormation() throws Exception {
        Wait.waitFor(new Wait.Condition(){

            public boolean isSatisified() throws Exception {
                return !((NetworkConnector)NoDuplicateOnTopicNetworkTest.this.broker3.getNetworkConnectors().get(0)).activeBridges().isEmpty();
            }
        });
        Wait.waitFor(new Wait.Condition(){

            public boolean isSatisified() throws Exception {
                return !((NetworkConnector)NoDuplicateOnTopicNetworkTest.this.broker2.getNetworkConnectors().get(0)).activeBridges().isEmpty();
            }
        });
        Wait.waitFor(new Wait.Condition(){

            public boolean isSatisified() throws Exception {
                return !((NetworkConnector)NoDuplicateOnTopicNetworkTest.this.broker1.getNetworkConnectors().get(0)).activeBridges().isEmpty();
            }
        });
    }

    private BrokerService createAndStartBroker(String name, String addr) throws Exception {
        BrokerService broker = new BrokerService();
        broker.setBrokerName(name);
        broker.addConnector(addr).setDiscoveryUri(new URI(MULTICAST_DEFAULT));
        broker.setUseJmx(false);
        NetworkConnector networkConnector = broker.addNetworkConnector(MULTICAST_DEFAULT);
        networkConnector.setDecreaseNetworkConsumerPriority(true);
        networkConnector.setDynamicOnly(this.dynamicOnly);
        networkConnector.setNetworkTTL(this.ttl);
        networkConnector.setSuppressDuplicateTopicSubscriptions(this.suppressDuplicateTopicSubs);
        PolicyMap policyMap = new PolicyMap();
        PolicyEntry policy = new PolicyEntry();
        policy.setDispatchPolicy(this.dispatchPolicy);
        policy.setEnableAudit(false);
        policyMap.put((ActiveMQDestination)new ActiveMQTopic(TOPIC_NAME), (Object)policy);
        broker.setDestinationPolicy(policyMap);
        broker.start();
        return broker;
    }

    protected void tearDown() throws Exception {
        this.broker1.stop();
        this.broker2.stop();
        this.broker3.stop();
        super.tearDown();
    }

    public void initCombosForTestProducerConsumerTopic() {
        this.addCombinationValues("suppresDuplicateTopicSubs", new Object[]{Boolean.TRUE, Boolean.FALSE});
        this.addCombinationValues("dispatchPolicy", new Object[]{new PriorityNetworkDispatchPolicy(), new SimpleDispatchPolicy()});
    }

    public void testProducerConsumerTopic() throws Exception {
        final CountDownLatch consumerStarted = new CountDownLatch(1);
        Thread producerThread2 = new Thread(new Runnable(){

            public void run() {
                TopicWithDuplicateMessages producer = new TopicWithDuplicateMessages();
                producer.setBrokerURL(NoDuplicateOnTopicNetworkTest.BROKER_1);
                producer.setTopicName(NoDuplicateOnTopicNetworkTest.TOPIC_NAME);
                try {
                    producer.produce();
                }
                catch (JMSException e) {
                    Assert.fail((String)("Unexpected " + (Object)((Object)e)));
                }
            }
        });
        final TopicWithDuplicateMessages consumer = new TopicWithDuplicateMessages();
        Thread consumerThread2 = new Thread(new Runnable(){

            public void run() {
                consumer.setBrokerURL(NoDuplicateOnTopicNetworkTest.BROKER_2);
                consumer.setTopicName(NoDuplicateOnTopicNetworkTest.TOPIC_NAME);
                try {
                    consumer.consumer();
                    consumerStarted.countDown();
                    consumer.getLatch().await(60L, TimeUnit.SECONDS);
                }
                catch (Exception e) {
                    Assert.fail((String)("Unexpected " + e));
                }
            }
        });
        consumerThread2.start();
        LOG.info((Object)"Started Consumer");
        NoDuplicateOnTopicNetworkTest.assertTrue((String)"consumer started eventually", (boolean)consumerStarted.await(10L, TimeUnit.SECONDS));
        Thread.sleep(2000L);
        producerThread2.start();
        LOG.info((Object)"Started Producer");
        producerThread2.join();
        consumerThread2.join();
        int duplicateCount = 0;
        HashMap<String, String> map = new HashMap<String, String>();
        for (String msg : consumer.getMessageStrings()) {
            if (map.containsKey(msg)) {
                LOG.info((Object)("got duplicate: " + msg));
                ++duplicateCount;
            }
            map.put(msg, msg);
        }
        if (this.suppressDuplicateTopicSubs || this.dispatchPolicy instanceof PriorityNetworkDispatchPolicy) {
            NoDuplicateOnTopicNetworkTest.assertEquals((String)"no duplicates", (int)0, (int)duplicateCount);
            NoDuplicateOnTopicNetworkTest.assertEquals((String)("got all required messages: " + map.size()), (int)consumer.getNumMessages(), (int)map.size());
        } else {
            NoDuplicateOnTopicNetworkTest.assertTrue((String)("we can get some duplicates: " + duplicateCount), (duplicateCount >= 0 ? 1 : 0) != 0);
            if (duplicateCount == 0) {
                NoDuplicateOnTopicNetworkTest.assertEquals((String)("got all required messages: " + map.size()), (int)consumer.getNumMessages(), (int)map.size());
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class TopicWithDuplicateMessages {
        private String brokerURL;
        private String topicName;
        private Connection connection;
        private Session session;
        private Topic topic;
        private MessageProducer producer;
        private MessageConsumer consumer;
        private List<String> receivedStrings = Collections.synchronizedList(new ArrayList());
        private int numMessages = 10;
        private CountDownLatch recievedLatch = new CountDownLatch(this.numMessages);

        TopicWithDuplicateMessages() {
        }

        public CountDownLatch getLatch() {
            return this.recievedLatch;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List<String> getMessageStrings() {
            List<String> list = this.receivedStrings;
            synchronized (list) {
                return new ArrayList<String>(this.receivedStrings);
            }
        }

        public String getBrokerURL() {
            return this.brokerURL;
        }

        public void setBrokerURL(String brokerURL) {
            this.brokerURL = brokerURL;
        }

        public String getTopicName() {
            return this.topicName;
        }

        public void setTopicName(String topicName) {
            this.topicName = topicName;
        }

        private void createConnection() throws JMSException {
            ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory(this.brokerURL);
            this.connection = factory.createConnection();
        }

        private void createTopic() throws JMSException {
            this.session = this.connection.createSession(false, 1);
            this.topic = this.session.createTopic(this.topicName);
        }

        private void createProducer() throws JMSException {
            this.producer = this.session.createProducer((Destination)this.topic);
        }

        private void createConsumer() throws JMSException {
            this.consumer = this.session.createConsumer((Destination)this.topic);
            this.consumer.setMessageListener(new MessageListener(){

                public void onMessage(Message arg0) {
                    TextMessage msg = (TextMessage)arg0;
                    try {
                        LOG.debug((Object)("Received message [" + msg.getText() + "]"));
                        TopicWithDuplicateMessages.this.receivedStrings.add(msg.getText());
                        TopicWithDuplicateMessages.this.recievedLatch.countDown();
                    }
                    catch (JMSException e) {
                        Assert.fail((String)("Unexpected :" + (Object)((Object)e)));
                    }
                }
            });
        }

        private void publish() throws JMSException {
            for (int i = 0; i < this.numMessages; ++i) {
                TextMessage textMessage = this.session.createTextMessage();
                String message = "message: " + i;
                LOG.debug((Object)("Sending message[" + message + "]"));
                textMessage.setText(message);
                this.producer.send((Message)textMessage);
            }
        }

        public void produce() throws JMSException {
            this.createConnection();
            this.createTopic();
            this.createProducer();
            this.connection.start();
            this.publish();
        }

        public void consumer() throws JMSException {
            this.createConnection();
            this.createTopic();
            this.createConsumer();
            this.connection.start();
        }

        public int getNumMessages() {
            return this.numMessages;
        }
    }
}

