/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.usecases;

import java.net.URI;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.TextMessage;
import junit.framework.TestCase;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerFactory;
import org.apache.activemq.broker.BrokerService;

public class TestBrokerConnectionDuplexExcludedDestinations
extends TestCase {
    BrokerService receiverBroker;
    BrokerService senderBroker;
    Connection hubConnection;
    Session hubSession;
    Connection spokeConnection;
    Session spokeSession;

    public void setUp() throws Exception {
        String configFileName = "org/apache/activemq/usecases/receiver-duplex.xml";
        URI uri = new URI("xbean:" + configFileName);
        this.receiverBroker = BrokerFactory.createBroker((URI)uri);
        this.receiverBroker.setPersistent(false);
        this.receiverBroker.setBrokerName("Hub");
        configFileName = "org/apache/activemq/usecases/sender-duplex.xml";
        uri = new URI("xbean:" + configFileName);
        this.senderBroker = BrokerFactory.createBroker((URI)uri);
        this.senderBroker.setPersistent(false);
        this.senderBroker.setBrokerName("Spoke");
        this.receiverBroker.start();
        this.senderBroker.start();
        ActiveMQConnectionFactory cfHub = new ActiveMQConnectionFactory("tcp://localhost:62002");
        this.hubConnection = cfHub.createConnection();
        this.hubConnection.start();
        this.hubSession = this.hubConnection.createSession(false, 1);
        ActiveMQConnectionFactory cfSpoke = new ActiveMQConnectionFactory("tcp://localhost:62001");
        this.spokeConnection = cfSpoke.createConnection();
        this.spokeConnection.start();
        this.spokeSession = this.spokeConnection.createSession(false, 1);
    }

    public void tearDown() throws Exception {
        this.hubSession.close();
        this.hubConnection.stop();
        this.hubConnection.close();
        this.spokeSession.close();
        this.spokeConnection.stop();
        this.spokeConnection.close();
        this.senderBroker.stop();
        this.receiverBroker.stop();
    }

    public void testDuplexSendFromHubToSpoke() throws Exception {
        MessageProducer hubProducer = this.hubSession.createProducer(null);
        hubProducer.setDeliveryMode(1);
        hubProducer.setDisableMessageID(true);
        hubProducer.setDisableMessageTimestamp(true);
        Queue excludedQueueHub = this.hubSession.createQueue("exclude.test.foo");
        TextMessage excludedMsgHub = this.hubSession.createTextMessage();
        excludedMsgHub.setText(excludedQueueHub.toString());
        Queue includedQueueHub = this.hubSession.createQueue("include.test.foo");
        TextMessage includedMsgHub = this.hubSession.createTextMessage();
        includedMsgHub.setText(includedQueueHub.toString());
        hubProducer.send((Destination)excludedQueueHub, (Message)excludedMsgHub);
        hubProducer.send((Destination)includedQueueHub, (Message)includedMsgHub);
        Queue excludedQueueSpoke = this.spokeSession.createQueue("exclude.test.foo");
        MessageConsumer excludedConsumerSpoke = this.spokeSession.createConsumer((Destination)excludedQueueSpoke);
        Thread.sleep(100L);
        Queue includedQueueSpoke = this.spokeSession.createQueue("include.test.foo");
        MessageConsumer includedConsumerSpoke = this.spokeSession.createConsumer((Destination)includedQueueSpoke);
        Message msg = excludedConsumerSpoke.receive(200L);
        TestBrokerConnectionDuplexExcludedDestinations.assertNull((Object)msg);
        msg = includedConsumerSpoke.receive(200L);
        TestBrokerConnectionDuplexExcludedDestinations.assertEquals((Object)includedMsgHub, (Object)msg);
        MessageConsumer excludedConsumerHub = this.hubSession.createConsumer((Destination)excludedQueueHub);
        msg = excludedConsumerHub.receive(200L);
        TestBrokerConnectionDuplexExcludedDestinations.assertEquals((Object)excludedMsgHub, (Object)msg);
        hubProducer.close();
        excludedConsumerSpoke.close();
    }
}

