/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.usecases;

import java.util.Arrays;
import java.util.concurrent.atomic.AtomicLong;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.Session;
import junit.framework.TestCase;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.region.policy.PolicyEntry;
import org.apache.activemq.broker.region.policy.PolicyMap;
import org.apache.activemq.command.ActiveMQTopic;
import org.apache.activemq.util.Wait;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TopicProducerFlowControlTest
extends TestCase
implements MessageListener {
    private static final Log LOG = LogFactory.getLog(TopicProducerFlowControlTest.class);
    private static final String brokerName = "testBroker";
    private static final String brokerUrl = "vm://testBroker";
    private static final int destinationMemLimit = 0x200000;
    private static final AtomicLong produced = new AtomicLong();
    private static final AtomicLong consumed = new AtomicLong();
    private static final int numMessagesToSend = 50000;
    private BrokerService broker;

    protected void setUp() throws Exception {
        this.broker = new BrokerService();
        this.broker.setBrokerName(brokerName);
        this.broker.setPersistent(false);
        this.broker.setSchedulerSupport(false);
        this.broker.setUseJmx(false);
        this.broker.setUseShutdownHook(false);
        this.broker.addConnector(brokerUrl);
        PolicyMap pm = new PolicyMap();
        PolicyEntry tpe = new PolicyEntry();
        tpe.setTopic(">");
        tpe.setMemoryLimit(0x200000L);
        tpe.setProducerFlowControl(true);
        PolicyEntry qpe = new PolicyEntry();
        qpe.setQueue(">");
        qpe.setMemoryLimit(0x200000L);
        qpe.setProducerFlowControl(true);
        qpe.setQueuePrefetch(1);
        pm.setPolicyEntries(Arrays.asList(tpe, qpe));
        this.broker.setDestinationPolicy(pm);
        this.broker.start();
        this.broker.waitUntilStarted();
    }

    protected void tearDown() throws Exception {
        this.broker.stop();
        this.broker.waitUntilStopped();
    }

    public void testTopicProducerFlowControl() throws Exception {
        ActiveMQTopic destination = new ActiveMQTopic("test");
        ActiveMQConnectionFactory connectionFactory = new ActiveMQConnectionFactory(brokerUrl);
        connectionFactory.setAlwaysSyncSend(true);
        connectionFactory.setProducerWindowSize(1024);
        Connection c = connectionFactory.createConnection();
        c.start();
        c.createSession(false, 1).createConsumer((Destination)destination).setMessageListener((MessageListener)new TopicProducerFlowControlTest());
        final Session session = connectionFactory.createConnection().createSession(false, 1);
        final MessageProducer producer = session.createProducer((Destination)destination);
        Thread producingThread = new Thread("Producing Thread"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    for (long i = 0L; i < 50000L; ++i) {
                        producer.send((Message)session.createTextMessage("test"));
                        long count = produced.incrementAndGet();
                        if (count % 100L != 0L) continue;
                        LOG.info((Object)("Produced " + count + " messages"));
                    }
                }
                catch (Throwable ex) {
                    ex.printStackTrace();
                }
                finally {
                    try {
                        producer.close();
                        session.close();
                    }
                    catch (Exception e) {}
                }
            }
        };
        producingThread.start();
        Wait.waitFor(new Wait.Condition(){

            public boolean isSatisified() throws Exception {
                return consumed.get() == 50000L;
            }
        }, 300000L);
        TopicProducerFlowControlTest.assertEquals((String)"Didn't produce all messages", (long)50000L, (long)produced.get());
        TopicProducerFlowControlTest.assertEquals((String)"Didn't consume all messages", (long)50000L, (long)consumed.get());
    }

    public void onMessage(Message message) {
        try {
            Thread.sleep(1L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        long count = consumed.incrementAndGet();
        if (count % 100L == 0L) {
            LOG.info((Object)("\tConsumed " + count + " messages"));
        }
    }
}

