/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.usecases;

import java.net.URI;
import javax.jms.Destination;
import javax.jms.MessageConsumer;
import org.apache.activemq.JmsMultipleBrokersTestSupport;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.util.MessageIdList;
import org.apache.activemq.util.Wait;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TwoBrokerNetworkLoadBalanceTest
extends JmsMultipleBrokersTestSupport {
    protected static final Log LOG = LogFactory.getLog(TwoBrokerNetworkLoadBalanceTest.class);

    public void testLoadBalancing() throws Exception {
        this.bridgeBrokers("BrokerA", "BrokerB");
        this.bridgeBrokers("BrokerB", "BrokerA");
        this.startAllBrokers();
        this.waitForBridgeFormation();
        ActiveMQDestination dest = this.createDestination("TEST.FOO", false);
        MessageConsumer clientA = this.createConsumer("BrokerA", (Destination)dest);
        MessageConsumer clientB = this.createConsumer("BrokerB", (Destination)dest);
        this.sendMessages("BrokerA", (Destination)dest, 5000);
        this.sendMessages("BrokerB", (Destination)dest, 1000);
        final MessageIdList msgsA = this.getConsumerMessages("BrokerA", clientA);
        final MessageIdList msgsB = this.getConsumerMessages("BrokerB", clientB);
        Wait.waitFor(new Wait.Condition(){

            public boolean isSatisified() throws Exception {
                return msgsA.getMessageCount() + msgsB.getMessageCount() == 6000;
            }
        });
        LOG.info((Object)("A got: " + msgsA.getMessageCount()));
        LOG.info((Object)("B got: " + msgsB.getMessageCount()));
        TwoBrokerNetworkLoadBalanceTest.assertTrue((String)("B got is fair share: " + msgsB.getMessageCount()), (msgsB.getMessageCount() > 2000 ? 1 : 0) != 0);
    }

    public void setUp() throws Exception {
        super.setAutoFail(true);
        super.setUp();
        this.createBroker(new URI("broker:(tcp://localhost:61616)/BrokerA?persistent=false&useJmx=false"));
        this.createBroker(new URI("broker:(tcp://localhost:61617)/BrokerB?persistent=false&useJmx=false"));
    }
}

