/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.util;

import junit.framework.TestCase;
import org.apache.activemq.util.BitArrayBin;

public class BitArrayBinTest
extends TestCase {
    public void testSetAroundWindow() throws Exception {
        this.doTestSetAroundWindow(500, 2000);
        this.doTestSetAroundWindow(512, 2000);
        this.doTestSetAroundWindow(128, 512);
    }

    public void testSetHiLo() throws Exception {
        BitArrayBin toTest = new BitArrayBin(50);
        toTest.setBit(0L, true);
        toTest.setBit(100L, true);
        toTest.setBit(150L, true);
        BitArrayBinTest.assertTrue((String)"set", (boolean)toTest.getBit(0L));
        toTest.setBit(0L, true);
        BitArrayBinTest.assertTrue((String)"set", (boolean)toTest.getBit(0L));
    }

    private void doTestSetAroundWindow(int window, int dataSize) throws Exception {
        int i;
        BitArrayBin toTest = new BitArrayBin(window);
        for (int i2 = 0; i2 <= dataSize; ++i2) {
            BitArrayBinTest.assertTrue((String)"not already set", (!toTest.setBit((long)i2, Boolean.TRUE.booleanValue()) ? 1 : 0) != 0);
            BitArrayBinTest.assertEquals((String)"current is max", (long)i2, (long)toTest.getLastSetIndex());
        }
        BitArrayBinTest.assertEquals((String)"last is max", (long)dataSize, (long)toTest.getLastSetIndex());
        int windowOfValidData = this.roundWindow(dataSize, window);
        for (i = dataSize; i >= dataSize - windowOfValidData; --i) {
            BitArrayBinTest.assertTrue((String)("was already set, id=" + i), (boolean)toTest.setBit((long)i, Boolean.TRUE.booleanValue()));
        }
        BitArrayBinTest.assertEquals((String)"last is still max", (long)dataSize, (long)toTest.getLastSetIndex());
        while (i >= 0) {
            BitArrayBinTest.assertTrue((String)("was not already set, id=" + i), (!toTest.setBit((long)i, Boolean.TRUE.booleanValue()) ? 1 : 0) != 0);
            --i;
        }
        for (int j = dataSize + 1; j <= 2 * dataSize; ++j) {
            BitArrayBinTest.assertTrue((String)("not already set: id=" + j), (!toTest.setBit((long)j, Boolean.TRUE.booleanValue()) ? 1 : 0) != 0);
        }
        BitArrayBinTest.assertEquals((String)"last still max*2", (long)(2 * dataSize), (long)toTest.getLastSetIndex());
    }

    public void testSetUnsetAroundWindow() throws Exception {
        this.doTestSetUnSetAroundWindow(500, 2000);
        this.doTestSetUnSetAroundWindow(512, 2000);
        this.doTestSetUnSetAroundWindow(128, 512);
    }

    private void doTestSetUnSetAroundWindow(int dataSize, int window) throws Exception {
        int i;
        BitArrayBin toTest = new BitArrayBin(window);
        for (int i2 = 0; i2 <= dataSize; ++i2) {
            BitArrayBinTest.assertTrue((String)"not already set", (!toTest.setBit((long)i2, Boolean.TRUE.booleanValue()) ? 1 : 0) != 0);
        }
        int windowOfValidData = this.roundWindow(dataSize, window);
        for (i = dataSize; i >= 0 && i >= dataSize - windowOfValidData; --i) {
            BitArrayBinTest.assertTrue((String)("was already set, id=" + i), (boolean)toTest.setBit((long)i, Boolean.FALSE.booleanValue()));
        }
        for (i = 0; i <= dataSize; ++i) {
            BitArrayBinTest.assertTrue((String)("not already set, id:" + i), (!toTest.setBit((long)i, Boolean.TRUE.booleanValue()) ? 1 : 0) != 0);
        }
        for (int j = 2 * dataSize; j < 4 * dataSize; ++j) {
            BitArrayBinTest.assertTrue((String)("not already set: id=" + j), (!toTest.setBit((long)j, Boolean.TRUE.booleanValue()) ? 1 : 0) != 0);
        }
    }

    public void testSetAroundLongSizeMultiplier() throws Exception {
        int window = 512;
        int dataSize = 1000;
        for (int muliplier = 1; muliplier < 8; ++muliplier) {
            for (int value = 0; value < dataSize; ++value) {
                BitArrayBin toTest = new BitArrayBin(window);
                int instance = value + muliplier * 64;
                BitArrayBinTest.assertTrue((String)("not already set: id=" + instance), (!toTest.setBit((long)instance, Boolean.TRUE.booleanValue()) ? 1 : 0) != 0);
                BitArrayBinTest.assertTrue((String)("not already set: id=" + value), (!toTest.setBit((long)value, Boolean.TRUE.booleanValue()) ? 1 : 0) != 0);
                BitArrayBinTest.assertEquals((String)"max set correct", (long)instance, (long)toTest.getLastSetIndex());
            }
        }
    }

    public void testLargeGapInData(int window) throws Exception {
        this.doTestLargeGapInData(128);
        this.doTestLargeGapInData(500);
    }

    public void doTestLargeGapInData(int window) throws Exception {
        BitArrayBin toTest = new BitArrayBin(window);
        int instance = 64;
        BitArrayBinTest.assertTrue((String)("not already set: id=" + instance), (!toTest.setBit((long)instance, Boolean.TRUE.booleanValue()) ? 1 : 0) != 0);
        instance = 768;
        BitArrayBinTest.assertTrue((String)("not already set: id=" + instance), (!toTest.setBit((long)instance, Boolean.TRUE.booleanValue()) ? 1 : 0) != 0);
        instance = 576;
        BitArrayBinTest.assertTrue((String)("not already set: id=" + instance), (!toTest.setBit((long)instance, Boolean.TRUE.booleanValue()) ? 1 : 0) != 0);
    }

    public void testLastSeq() throws Exception {
        BitArrayBin toTest = new BitArrayBin(512);
        BitArrayBinTest.assertEquals((String)"last not set", (long)-1L, (long)toTest.getLastSetIndex());
        toTest.setBit(1L, Boolean.TRUE.booleanValue());
        BitArrayBinTest.assertEquals((String)"last correct", (long)1L, (long)toTest.getLastSetIndex());
        toTest.setBit(64L, Boolean.TRUE.booleanValue());
        BitArrayBinTest.assertEquals((String)"last correct", (long)64L, (long)toTest.getLastSetIndex());
        toTest.setBit(68L, Boolean.TRUE.booleanValue());
        BitArrayBinTest.assertEquals((String)"last correct", (long)68L, (long)toTest.getLastSetIndex());
    }

    private int roundWindow(int dataSetEnd, int windowSize) {
        int validData = dataSetEnd - windowSize;
        int validDataBin = validData / 64;
        int startOfValid = (validDataBin += windowSize % 64 > 0 ? 1 : 0) * 64;
        return dataSetEnd - startOfValid;
    }
}

