/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.util;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import junit.framework.TestCase;
import org.apache.activemq.util.URISupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class URISupportTest
extends TestCase {
    public void testEmptyCompositePath() throws Exception {
        URISupport.CompositeData data = URISupport.parseComposite((URI)new URI("broker:()/localhost?persistent=false"));
        URISupportTest.assertEquals((int)0, (int)data.getComponents().length);
    }

    public void testCompositePath() throws Exception {
        URISupport.CompositeData data = URISupport.parseComposite((URI)new URI("test:(path)/path"));
        URISupportTest.assertEquals((String)"path", (String)data.getPath());
        data = URISupport.parseComposite((URI)new URI("test:path"));
        URISupportTest.assertNull((Object)data.getPath());
    }

    public void testSimpleComposite() throws Exception {
        URISupport.CompositeData data = URISupport.parseComposite((URI)new URI("test:part1"));
        URISupportTest.assertEquals((int)1, (int)data.getComponents().length);
    }

    public void testComposite() throws Exception {
        URISupport.CompositeData data = URISupport.parseComposite((URI)new URI("test:(part1://host,part2://(sub1://part,sube2:part))"));
        URISupportTest.assertEquals((int)2, (int)data.getComponents().length);
    }

    public void testCompositeWithComponentParam() throws Exception {
        URISupport.CompositeData data = URISupport.parseComposite((URI)new URI("test:(part1://host?part1=true)?outside=true"));
        URISupportTest.assertEquals((int)1, (int)data.getComponents().length);
        URISupportTest.assertEquals((int)1, (int)data.getParameters().size());
        Map part1Params = URISupport.parseParameters((URI)data.getComponents()[0]);
        URISupportTest.assertEquals((int)1, (int)part1Params.size());
        URISupportTest.assertTrue((boolean)part1Params.containsKey("part1"));
    }

    public void testParsingURI() throws Exception {
        URI source = new URI("tcp://localhost:61626/foo/bar?cheese=Edam&x=123");
        Map map = URISupport.parseParameters((URI)source);
        URISupportTest.assertEquals((String)("Size: " + map), (int)2, (int)map.size());
        this.assertMapKey(map, "cheese", "Edam");
        this.assertMapKey(map, "x", "123");
        URI result = URISupport.removeQuery((URI)source);
        URISupportTest.assertEquals((String)"result", (Object)new URI("tcp://localhost:61626/foo/bar"), (Object)result);
    }

    protected void assertMapKey(Map map, String key, Object expected) {
        URISupportTest.assertEquals((String)("Map key: " + key), map.get(key), (Object)expected);
    }

    public void testParsingCompositeURI() throws URISyntaxException {
        URISupport.CompositeData data = URISupport.parseComposite((URI)new URI("broker://(tcp://localhost:61616)?name=foo"));
        URISupportTest.assertEquals((String)"one component", (int)1, (int)data.getComponents().length);
        URISupportTest.assertEquals((String)("Size: " + data.getParameters()), (int)1, (int)data.getParameters().size());
    }

    public void testCheckParenthesis() throws Exception {
        String str = "fred:(((ddd))";
        URISupportTest.assertFalse((boolean)URISupport.checkParenthesis((String)str));
        str = str + ")";
        URISupportTest.assertTrue((boolean)URISupport.checkParenthesis((String)str));
    }

    public void testCreateWithQuery() throws Exception {
        URI source = new URI("vm://localhost");
        URI dest = URISupport.createURIWithQuery((URI)source, (String)"network=true&one=two");
        URISupportTest.assertEquals((String)"correct param count", (int)2, (int)URISupport.parseParameters((URI)dest).size());
        URISupportTest.assertEquals((String)"same uri, host", (String)source.getHost(), (String)dest.getHost());
        URISupportTest.assertEquals((String)"same uri, scheme", (String)source.getScheme(), (String)dest.getScheme());
        URISupportTest.assertFalse((String)"same uri, ssp", (boolean)dest.getQuery().equals(source.getQuery()));
    }

    public void testParsingParams() throws Exception {
        URI uri = new URI("static:(http://localhost:61617?proxyHost=localhost&proxyPort=80)");
        Map parameters = URISupport.parseParameters((URI)uri);
        this.verifyParams(parameters);
        uri = new URI("static://http://localhost:61617?proxyHost=localhost&proxyPort=80");
        parameters = URISupport.parseParameters((URI)uri);
        this.verifyParams(parameters);
        uri = new URI("http://0.0.0.0:61616");
        parameters = URISupport.parseParameters((URI)uri);
    }

    private void verifyParams(Map<String, String> parameters) {
        URISupportTest.assertEquals((String)parameters.get("proxyHost"), (String)"localhost");
        URISupportTest.assertEquals((String)parameters.get("proxyPort"), (String)"80");
    }
}

