/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.xbean;

import java.net.URI;
import java.util.List;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TextMessage;
import junit.framework.TestCase;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.TransportConnector;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.command.ActiveMQTopic;
import org.apache.activemq.network.NetworkConnector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ConnectorXBeanConfigTest
extends TestCase {
    private static final Log LOG = LogFactory.getLog(ConnectorXBeanConfigTest.class);
    protected BrokerService brokerService;

    public void testConnectorConfiguredCorrectly() throws Exception {
        TransportConnector connector = (TransportConnector)this.brokerService.getTransportConnectors().get(0);
        ConnectorXBeanConfigTest.assertEquals((Object)new URI("tcp://localhost:61636"), (Object)connector.getUri());
        ConnectorXBeanConfigTest.assertTrue((connector.getTaskRunnerFactory() == this.brokerService.getTaskRunnerFactory() ? 1 : 0) != 0);
        NetworkConnector netConnector = (NetworkConnector)this.brokerService.getNetworkConnectors().get(0);
        List excludedDestinations = netConnector.getExcludedDestinations();
        ConnectorXBeanConfigTest.assertEquals((Object)new ActiveMQQueue("exclude.test.foo"), excludedDestinations.get(0));
        ConnectorXBeanConfigTest.assertEquals((Object)new ActiveMQTopic("exclude.test.bar"), excludedDestinations.get(1));
        List dynamicallyIncludedDestinations = netConnector.getDynamicallyIncludedDestinations();
        ConnectorXBeanConfigTest.assertEquals((Object)new ActiveMQQueue("include.test.foo"), dynamicallyIncludedDestinations.get(0));
        ConnectorXBeanConfigTest.assertEquals((Object)new ActiveMQTopic("include.test.bar"), dynamicallyIncludedDestinations.get(1));
    }

    public void testBrokerRestartIsAllowed() throws Exception {
        this.brokerService.stop();
        this.brokerService.waitUntilStopped();
        this.brokerService.start();
    }

    public void testForceBrokerRestart() throws Exception {
        this.brokerService.stop();
        this.brokerService.waitUntilStopped();
        this.brokerService.start(true);
        this.brokerService.waitUntilStarted();
        LOG.info((Object)"try and connect to restarted broker");
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory("tcp://localhost:61636");
        Connection conn = factory.createConnection();
        Session sess = conn.createSession(false, 1);
        conn.start();
        ActiveMQQueue dest = new ActiveMQQueue("test");
        MessageProducer producer = sess.createProducer((Destination)dest);
        MessageConsumer consumer = sess.createConsumer((Destination)dest);
        producer.send((Message)sess.createTextMessage("test"));
        TextMessage msg = (TextMessage)consumer.receive(1000L);
        ConnectorXBeanConfigTest.assertEquals((String)"test", (String)msg.getText());
    }

    protected void setUp() throws Exception {
        this.brokerService = this.createBroker();
        this.brokerService.start();
    }

    protected void tearDown() throws Exception {
        if (this.brokerService != null) {
            this.brokerService.stop();
        }
    }

    protected BrokerService createBroker() throws Exception {
        String uri = "org/apache/activemq/xbean/connector-test.xml";
        return BrokerFactory.createBroker((URI)new URI("xbean:" + uri));
    }
}

