/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.xbean;

import java.net.URI;
import java.util.HashMap;
import java.util.Hashtable;
import javax.management.MBeanServerConnection;
import javax.management.MBeanServerInvocationHandler;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import junit.framework.TestCase;
import org.apache.activemq.broker.BrokerFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.jmx.BrokerViewMBean;
import org.apache.activemq.util.JMXSupport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ManagementContextXBeanConfigTest
extends TestCase {
    protected BrokerService brokerService;
    private static final transient Log LOG = LogFactory.getLog(ManagementContextXBeanConfigTest.class);

    public void testManagmentContextConfiguredCorrectly() throws Exception {
        ManagementContextXBeanConfigTest.assertEquals((int)2011, (int)this.brokerService.getManagementContext().getConnectorPort());
        ManagementContextXBeanConfigTest.assertEquals((String)"test.domain", (String)this.brokerService.getManagementContext().getJmxDomainName());
        Hashtable<String, String> map = new Hashtable<String, String>();
        map.put("Type", "Broker");
        map.put("BrokerName", JMXSupport.encodeObjectNamePart((String)"localhost"));
        ObjectName on = new ObjectName("test.domain", map);
        Object value = this.brokerService.getManagementContext().getAttribute(on, "TotalEnqueueCount");
        ManagementContextXBeanConfigTest.assertNotNull((Object)value);
    }

    public void testSuccessAuthentication() throws Exception {
        JMXServiceURL url = new JMXServiceURL("service:jmx:rmi:///jndi/rmi://localhost:2011/jmxrmi");
        HashMap<String, String[]> env = new HashMap<String, String[]>();
        env.put("jmx.remote.credentials", new String[]{"admin", "activemq"});
        JMXConnector connector = JMXConnectorFactory.connect(url, env);
        this.assertAuthentication(connector);
    }

    public void testFailAuthentication() throws Exception {
        JMXServiceURL url = new JMXServiceURL("service:jmx:rmi:///jndi/rmi://localhost:2011/jmxrmi");
        try {
            JMXConnector connector = JMXConnectorFactory.connect(url, null);
            this.assertAuthentication(connector);
        }
        catch (SecurityException e) {
            return;
        }
        ManagementContextXBeanConfigTest.fail((String)"Should have thrown an exception");
    }

    public void assertAuthentication(JMXConnector connector) throws Exception {
        connector.connect();
        MBeanServerConnection connection = connector.getMBeanServerConnection();
        ObjectName name = new ObjectName("test.domain:BrokerName=localhost,Type=Broker");
        BrokerViewMBean mbean = MBeanServerInvocationHandler.newProxyInstance(connection, name, BrokerViewMBean.class, true);
        LOG.info((Object)("Broker " + mbean.getBrokerId() + " - " + mbean.getBrokerName()));
    }

    protected void setUp() throws Exception {
        this.brokerService = this.createBroker();
        this.brokerService.start();
    }

    protected void tearDown() throws Exception {
        if (this.brokerService != null) {
            this.brokerService.stop();
        }
    }

    protected BrokerService createBroker() throws Exception {
        String uri = "org/apache/activemq/xbean/management-context-test.xml";
        return BrokerFactory.createBroker((URI)new URI("xbean:" + uri));
    }
}

