/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.component.repository;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.codehaus.plexus.ClassRealmUtil;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.codehaus.plexus.component.CastUtils;
import org.codehaus.plexus.component.composition.CompositionResolver;
import org.codehaus.plexus.component.composition.CycleDetectedInComponentGraphException;
import org.codehaus.plexus.component.composition.DefaultCompositionResolver;
import org.codehaus.plexus.component.repository.ComponentDescriptor;
import org.codehaus.plexus.component.repository.ComponentRepository;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultComponentRepository
extends AbstractLogEnabled
implements ComponentRepository {
    private final Map<ClassRealm, SortedMap<String, Multimap<String, ComponentDescriptor<?>>>> index = new LinkedHashMap();
    private final CompositionResolver compositionResolver = new DefaultCompositionResolver();

    private Multimap<String, ComponentDescriptor<?>> getComponentDescriptors(String role) {
        if (role == null) {
            throw new NullPointerException("role is null");
        }
        Set<ClassRealm> realms = ClassRealmUtil.getContextRealms(null);
        if (realms.isEmpty()) {
            realms.addAll(this.index.keySet());
        }
        LinkedHashMultimap roleHintIndex = LinkedHashMultimap.create();
        for (ClassRealm realm : realms) {
            Multimap descriptors;
            SortedMap<String, Multimap<String, ComponentDescriptor<?>>> roleIndex = this.index.get(realm);
            if (roleIndex == null || (descriptors = (Multimap)roleIndex.get(role)) == null) continue;
            roleHintIndex.putAll(descriptors);
        }
        return Multimaps.unmodifiableMultimap(roleHintIndex);
    }

    @Override
    public <T> ComponentDescriptor<T> getComponentDescriptor(Class<T> type, String role, String roleHint) {
        Collection<ComponentDescriptor<?>> descriptors;
        Multimap<String, ComponentDescriptor<?>> roleHintIndex = this.getComponentDescriptors(role);
        if (StringUtils.isNotEmpty(roleHint)) {
            descriptors = roleHintIndex.get(roleHint);
        } else {
            ArrayList allDescriptors = new ArrayList();
            descriptors = roleHintIndex.get("default");
            if (descriptors != null) {
                allDescriptors.addAll(descriptors);
            }
            for (String hint : roleHintIndex.keySet()) {
                descriptors = roleHintIndex.get(hint);
                if (descriptors == null) continue;
                allDescriptors.addAll(descriptors);
            }
            descriptors = allDescriptors;
        }
        for (ComponentDescriptor<?> descriptor : descriptors) {
            Class<?> implClass = descriptor.getImplementationClass();
            if (CastUtils.isAssignableFrom(type, implClass)) {
                return descriptor;
            }
            if (Object.class != implClass || !role.equals(type.getName())) continue;
            return descriptor;
        }
        return null;
    }

    @Override
    public <T> Map<String, ComponentDescriptor<T>> getComponentDescriptorMap(Class<T> type, String role) {
        TreeMap<String, ComponentDescriptor<T>> descriptors = new TreeMap<String, ComponentDescriptor<T>>();
        for (ComponentDescriptor<?> descriptor : this.getComponentDescriptors(role).values()) {
            if (descriptors.containsKey(descriptor.getRoleHint()) || !CastUtils.isAssignableFrom(type, descriptor.getImplementationClass())) continue;
            descriptors.put(descriptor.getRoleHint(), descriptor);
        }
        return descriptors;
    }

    @Override
    public <T> List<ComponentDescriptor<T>> getComponentDescriptorList(Class<T> type, String role) {
        ArrayList<ComponentDescriptor<T>> descriptors = new ArrayList<ComponentDescriptor<T>>();
        for (ComponentDescriptor<?> descriptor : this.getComponentDescriptors(role).values()) {
            if (!CastUtils.isAssignableFrom(type, descriptor.getImplementationClass())) continue;
            descriptors.add(descriptor);
        }
        return descriptors;
    }

    @Override
    @Deprecated
    public ComponentDescriptor<?> getComponentDescriptor(String role, String roleHint, ClassRealm realm) {
        HashSet<ClassRealm> realms = new HashSet<ClassRealm>();
        for (ClassRealm r = realm; r != null; r = r.getParentRealm()) {
            realms.add(r);
        }
        for (ComponentDescriptor<?> componentDescriptor : this.getComponentDescriptors(role).get(roleHint)) {
            if (!realms.contains(componentDescriptor.getRealm())) continue;
            return componentDescriptor;
        }
        return null;
    }

    @Override
    public void removeComponentRealm(ClassRealm classRealm) {
        this.index.remove(classRealm);
    }

    @Override
    public void addComponentDescriptor(ComponentDescriptor<?> componentDescriptor) throws CycleDetectedInComponentGraphException {
        String role;
        LinkedHashMultimap<String, ComponentDescriptor<?>> roleHintIndex;
        ClassRealm classRealm = componentDescriptor.getRealm();
        SortedMap<String, Multimap<String, ComponentDescriptor<?>>> roleIndex = this.index.get(classRealm);
        if (roleIndex == null) {
            roleIndex = new TreeMap();
            this.index.put(classRealm, roleIndex);
        }
        if ((roleHintIndex = (LinkedHashMultimap<String, ComponentDescriptor<?>>)roleIndex.get(role = componentDescriptor.getRole())) == null) {
            roleHintIndex = LinkedHashMultimap.create();
            roleIndex.put(role, roleHintIndex);
        }
        roleHintIndex.put(componentDescriptor.getRoleHint(), componentDescriptor);
        this.compositionResolver.addComponentDescriptor(componentDescriptor);
    }
}

