/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.store.jdbc;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.LinkedList;
import javax.sql.DataSource;
import org.apache.activemq.store.jdbc.JDBCPersistenceAdapter;
import org.apache.activemq.util.IOExceptionSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionContext {
    private static final Logger LOG = LoggerFactory.getLogger(TransactionContext.class);
    private final DataSource dataSource;
    private final JDBCPersistenceAdapter persistenceAdapter;
    private Connection connection;
    private boolean inTx;
    private PreparedStatement addMessageStatement;
    private PreparedStatement removedMessageStatement;
    private PreparedStatement updateLastAckStatement;
    private int transactionIsolation = 1;
    private LinkedList<Runnable> completions = new LinkedList();

    public TransactionContext(JDBCPersistenceAdapter persistenceAdapter) throws IOException {
        this.persistenceAdapter = persistenceAdapter;
        this.dataSource = persistenceAdapter.getDataSource();
    }

    public Connection getConnection() throws IOException {
        if (this.connection == null) {
            try {
                this.connection = this.dataSource.getConnection();
                if (this.persistenceAdapter.isChangeAutoCommitAllowed()) {
                    boolean autoCommit;
                    boolean bl = autoCommit = !this.inTx;
                    if (this.connection.getAutoCommit() != autoCommit) {
                        LOG.trace("Setting auto commit to {} on connection {}", (Object)autoCommit, (Object)this.connection);
                        this.connection.setAutoCommit(autoCommit);
                    }
                }
            }
            catch (SQLException e) {
                JDBCPersistenceAdapter.log("Could not get JDBC connection: ", e);
                this.inTx = false;
                this.close();
                IOException ioe = IOExceptionSupport.create((Exception)e);
                this.persistenceAdapter.getBrokerService().handleIOException(ioe);
                throw ioe;
            }
            try {
                this.connection.setTransactionIsolation(this.transactionIsolation);
            }
            catch (Throwable e) {
                LOG.trace("Cannot set transaction isolation to " + this.transactionIsolation + " due " + e.getMessage() + ". This exception is ignored.", e);
            }
        }
        return this.connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeBatch() throws SQLException {
        try {
            this.executeBatch(this.addMessageStatement, "Failed add a message");
        }
        finally {
            this.addMessageStatement = null;
            try {
                this.executeBatch(this.removedMessageStatement, "Failed to remove a message");
            }
            finally {
                this.removedMessageStatement = null;
                try {
                    this.executeBatch(this.updateLastAckStatement, "Failed to ack a message");
                }
                finally {
                    this.updateLastAckStatement = null;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeBatch(PreparedStatement p, String message) throws SQLException {
        if (p == null) {
            return;
        }
        try {
            int[] rc = p.executeBatch();
            for (int i = 0; i < rc.length; ++i) {
                int code = rc[i];
                if (code >= 0 || code == -2) continue;
                throw new SQLException(message + ". Response code: " + code);
            }
        }
        finally {
            try {
                p.close();
            }
            catch (Throwable throwable) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void close() throws IOException {
        if (this.inTx) return;
        try {
            try {
                this.executeBatch();
                return;
            }
            finally {
                if (this.connection != null && !this.connection.getAutoCommit()) {
                    this.connection.commit();
                }
            }
        }
        catch (SQLException e) {
            JDBCPersistenceAdapter.log("Error while closing connection: ", e);
            IOException ioe = IOExceptionSupport.create((Exception)e);
            this.persistenceAdapter.getBrokerService().handleIOException(ioe);
            throw ioe;
        }
        finally {
            try {
                if (this.connection != null) {
                    this.connection.close();
                }
            }
            catch (Throwable e) {
                LOG.trace("Closing connection failed due: " + e.getMessage() + ". This exception is ignored.", e);
            }
            finally {
                this.connection = null;
            }
            Iterator i$ = this.completions.iterator();
            while (true) {
                if (!i$.hasNext()) {
                }
                Runnable completion = (Runnable)i$.next();
                completion.run();
            }
        }
    }

    public void begin() throws IOException {
        if (this.inTx) {
            throw new IOException("Already started.");
        }
        this.inTx = true;
        this.connection = this.getConnection();
    }

    public void commit() throws IOException {
        if (!this.inTx) {
            throw new IOException("Not started.");
        }
        try {
            this.executeBatch();
            if (!this.connection.getAutoCommit()) {
                this.connection.commit();
            }
        }
        catch (SQLException e) {
            JDBCPersistenceAdapter.log("Commit failed: ", e);
            this.rollback();
            throw IOExceptionSupport.create((Exception)e);
        }
        finally {
            this.inTx = false;
            this.close();
        }
    }

    public void rollback() throws IOException {
        if (!this.inTx) {
            throw new IOException("Not started.");
        }
        try {
            if (this.addMessageStatement != null) {
                this.addMessageStatement.close();
                this.addMessageStatement = null;
            }
            if (this.removedMessageStatement != null) {
                this.removedMessageStatement.close();
                this.removedMessageStatement = null;
            }
            if (this.updateLastAckStatement != null) {
                this.updateLastAckStatement.close();
                this.updateLastAckStatement = null;
            }
            this.connection.rollback();
        }
        catch (SQLException e) {
            JDBCPersistenceAdapter.log("Rollback failed: ", e);
            throw IOExceptionSupport.create((Exception)e);
        }
        finally {
            this.inTx = false;
            this.close();
        }
    }

    public PreparedStatement getAddMessageStatement() {
        return this.addMessageStatement;
    }

    public void setAddMessageStatement(PreparedStatement addMessageStatement) {
        this.addMessageStatement = addMessageStatement;
    }

    public PreparedStatement getUpdateLastAckStatement() {
        return this.updateLastAckStatement;
    }

    public void setUpdateLastAckStatement(PreparedStatement ackMessageStatement) {
        this.updateLastAckStatement = ackMessageStatement;
    }

    public PreparedStatement getRemovedMessageStatement() {
        return this.removedMessageStatement;
    }

    public void setRemovedMessageStatement(PreparedStatement removedMessageStatement) {
        this.removedMessageStatement = removedMessageStatement;
    }

    public void setTransactionIsolation(int transactionIsolation) {
        this.transactionIsolation = transactionIsolation;
    }

    public void onCompletion(Runnable runnable) {
        this.completions.add(runnable);
    }
}

