/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.proton.codec.impl;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Date;
import java.util.UUID;
import org.apache.qpid.proton.amqp.Decimal128;
import org.apache.qpid.proton.amqp.Decimal32;
import org.apache.qpid.proton.amqp.Decimal64;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.UnsignedByte;
import org.apache.qpid.proton.amqp.UnsignedInteger;
import org.apache.qpid.proton.amqp.UnsignedLong;
import org.apache.qpid.proton.amqp.UnsignedShort;
import org.apache.qpid.proton.codec.Data;

class DataDecoder {
    private static final Charset ASCII = Charset.forName("US-ASCII");
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private static final TypeConstructor[] _constructors = new TypeConstructor[256];

    DataDecoder() {
    }

    static int decode(ByteBuffer b, Data data) {
        if (b.hasRemaining()) {
            int position = b.position();
            TypeConstructor c = DataDecoder.readConstructor(b);
            int size = c.size(b);
            if (b.remaining() >= size) {
                c.parse(b, data);
                return 1 + size;
            }
            b.position(position);
            return -4;
        }
        return 0;
    }

    private static TypeConstructor readConstructor(ByteBuffer b) {
        int index = b.get() & 0xFF;
        TypeConstructor tc = _constructors[index];
        if (tc == null) {
            throw new IllegalArgumentException("No constructor for type " + index);
        }
        return tc;
    }

    private static void parseChildren(Data data, ByteBuffer buf, int count) {
        data.enter();
        for (int i = 0; i < count; ++i) {
            int remaining;
            TypeConstructor c = DataDecoder.readConstructor(buf);
            int size = c.size(buf);
            if (size > (remaining = buf.remaining())) {
                throw new IllegalArgumentException("Malformed data");
            }
            c.parse(buf, data);
        }
        data.exit();
    }

    private static void parseArray(Data data, ByteBuffer buf, int count) {
        byte type = buf.get();
        boolean isDescribed = type == 0;
        int descriptorPosition = buf.position();
        if (isDescribed) {
            TypeConstructor descriptorTc = DataDecoder.readConstructor(buf);
            buf.position(buf.position() + descriptorTc.size(buf));
            type = buf.get();
            if (type == 0) {
                throw new IllegalArgumentException("Malformed array data");
            }
        }
        TypeConstructor tc = _constructors[type & 0xFF];
        data.putArray(isDescribed, tc.getType());
        data.enter();
        if (isDescribed) {
            int position = buf.position();
            buf.position(descriptorPosition);
            TypeConstructor descriptorTc = DataDecoder.readConstructor(buf);
            descriptorTc.parse(buf, data);
            buf.position(position);
        }
        for (int i = 0; i < count; ++i) {
            tc.parse(buf, data);
        }
        data.exit();
    }

    static {
        DataDecoder._constructors[0] = new DescribedTypeConstructor();
        DataDecoder._constructors[64] = new NullConstructor();
        DataDecoder._constructors[65] = new TrueConstructor();
        DataDecoder._constructors[66] = new FalseConstructor();
        DataDecoder._constructors[67] = new UInt0Constructor();
        DataDecoder._constructors[68] = new ULong0Constructor();
        DataDecoder._constructors[69] = new EmptyListConstructor();
        DataDecoder._constructors[80] = new UByteConstructor();
        DataDecoder._constructors[81] = new ByteConstructor();
        DataDecoder._constructors[82] = new SmallUIntConstructor();
        DataDecoder._constructors[83] = new SmallULongConstructor();
        DataDecoder._constructors[84] = new SmallIntConstructor();
        DataDecoder._constructors[85] = new SmallLongConstructor();
        DataDecoder._constructors[86] = new BooleanConstructor();
        DataDecoder._constructors[96] = new UShortConstructor();
        DataDecoder._constructors[97] = new ShortConstructor();
        DataDecoder._constructors[112] = new UIntConstructor();
        DataDecoder._constructors[113] = new IntConstructor();
        DataDecoder._constructors[114] = new FloatConstructor();
        DataDecoder._constructors[115] = new CharConstructor();
        DataDecoder._constructors[116] = new Decimal32Constructor();
        DataDecoder._constructors[128] = new ULongConstructor();
        DataDecoder._constructors[129] = new LongConstructor();
        DataDecoder._constructors[130] = new DoubleConstructor();
        DataDecoder._constructors[131] = new TimestampConstructor();
        DataDecoder._constructors[132] = new Decimal64Constructor();
        DataDecoder._constructors[148] = new Decimal128Constructor();
        DataDecoder._constructors[152] = new UUIDConstructor();
        DataDecoder._constructors[160] = new SmallBinaryConstructor();
        DataDecoder._constructors[161] = new SmallStringConstructor();
        DataDecoder._constructors[163] = new SmallSymbolConstructor();
        DataDecoder._constructors[176] = new BinaryConstructor();
        DataDecoder._constructors[177] = new StringConstructor();
        DataDecoder._constructors[179] = new SymbolConstructor();
        DataDecoder._constructors[192] = new SmallListConstructor();
        DataDecoder._constructors[193] = new SmallMapConstructor();
        DataDecoder._constructors[208] = new ListConstructor();
        DataDecoder._constructors[209] = new MapConstructor();
        DataDecoder._constructors[224] = new SmallArrayConstructor();
        DataDecoder._constructors[240] = new ArrayConstructor();
    }

    private static class ArrayConstructor
    extends VariableConstructor {
        private ArrayConstructor() {
        }

        @Override
        public Data.DataType getType() {
            return Data.DataType.ARRAY;
        }

        @Override
        public void parse(ByteBuffer b, Data data) {
            int size = b.getInt();
            ByteBuffer buf = b.slice();
            buf.limit(size);
            b.position(b.position() + size);
            int count = buf.getInt();
            DataDecoder.parseArray(data, buf, count);
        }
    }

    private static class SmallArrayConstructor
    extends SmallVariableConstructor {
        private SmallArrayConstructor() {
        }

        @Override
        public Data.DataType getType() {
            return Data.DataType.ARRAY;
        }

        @Override
        public void parse(ByteBuffer b, Data data) {
            int size = b.get() & 0xFF;
            ByteBuffer buf = b.slice();
            buf.limit(size);
            b.position(b.position() + size);
            int count = buf.get() & 0xFF;
            DataDecoder.parseArray(data, buf, count);
        }
    }

    private static class DescribedTypeConstructor
    implements TypeConstructor {
        private DescribedTypeConstructor() {
        }

        @Override
        public Data.DataType getType() {
            return Data.DataType.DESCRIBED;
        }

        @Override
        public int size(ByteBuffer b) {
            ByteBuffer buf = b.slice();
            if (buf.hasRemaining()) {
                TypeConstructor c = DataDecoder.readConstructor(buf);
                int size = c.size(buf);
                if (buf.remaining() > size) {
                    buf.position(size + 1);
                    c = DataDecoder.readConstructor(buf);
                    return size + 2 + c.size(buf);
                }
                return size + 2;
            }
            return 1;
        }

        @Override
        public void parse(ByteBuffer b, Data data) {
            data.putDescribed();
            data.enter();
            TypeConstructor c = DataDecoder.readConstructor(b);
            c.parse(b, data);
            c = DataDecoder.readConstructor(b);
            c.parse(b, data);
            data.exit();
        }
    }

    private static class MapConstructor
    extends VariableConstructor {
        private MapConstructor() {
        }

        @Override
        public Data.DataType getType() {
            return Data.DataType.MAP;
        }

        @Override
        public void parse(ByteBuffer b, Data data) {
            int size = b.getInt();
            ByteBuffer buf = b.slice();
            buf.limit(size);
            b.position(b.position() + size);
            int count = buf.getInt();
            data.putMap();
            DataDecoder.parseChildren(data, buf, count);
        }
    }

    private static class ListConstructor
    extends VariableConstructor {
        private ListConstructor() {
        }

        @Override
        public Data.DataType getType() {
            return Data.DataType.LIST;
        }

        @Override
        public void parse(ByteBuffer b, Data data) {
            int size = b.getInt();
            ByteBuffer buf = b.slice();
            buf.limit(size);
            b.position(b.position() + size);
            int count = buf.getInt();
            data.putList();
            DataDecoder.parseChildren(data, buf, count);
        }
    }

    private static class SmallMapConstructor
    extends SmallVariableConstructor {
        private SmallMapConstructor() {
        }

        @Override
        public Data.DataType getType() {
            return Data.DataType.MAP;
        }

        @Override
        public void parse(ByteBuffer b, Data data) {
            int size = b.get() & 0xFF;
            ByteBuffer buf = b.slice();
            buf.limit(size);
            b.position(b.position() + size);
            int count = buf.get() & 0xFF;
            data.putMap();
            DataDecoder.parseChildren(data, buf, count);
        }
    }

    private static class SmallListConstructor
    extends SmallVariableConstructor {
        private SmallListConstructor() {
        }

        @Override
        public Data.DataType getType() {
            return Data.DataType.LIST;
        }

        @Override
        public void parse(ByteBuffer b, Data data) {
            int size = b.get() & 0xFF;
            ByteBuffer buf = b.slice();
            buf.limit(size);
            b.position(b.position() + size);
            int count = buf.get() & 0xFF;
            data.putList();
            DataDecoder.parseChildren(data, buf, count);
        }
    }

    private static class StringConstructor
    extends VariableConstructor {
        private StringConstructor() {
        }

        @Override
        public Data.DataType getType() {
            return Data.DataType.STRING;
        }

        @Override
        public void parse(ByteBuffer b, Data data) {
            int size = b.getInt();
            byte[] bytes = new byte[size];
            b.get(bytes);
            data.putString(new String(bytes, UTF_8));
        }
    }

    private static class SymbolConstructor
    extends VariableConstructor {
        private SymbolConstructor() {
        }

        @Override
        public Data.DataType getType() {
            return Data.DataType.SYMBOL;
        }

        @Override
        public void parse(ByteBuffer b, Data data) {
            int size = b.getInt();
            byte[] bytes = new byte[size];
            b.get(bytes);
            data.putSymbol(Symbol.valueOf((String)new String(bytes, ASCII)));
        }
    }

    private static class BinaryConstructor
    extends VariableConstructor {
        private BinaryConstructor() {
        }

        @Override
        public Data.DataType getType() {
            return Data.DataType.BINARY;
        }

        @Override
        public void parse(ByteBuffer b, Data data) {
            int size = b.getInt();
            byte[] bytes = new byte[size];
            b.get(bytes);
            data.putBinary(bytes);
        }
    }

    private static class SmallStringConstructor
    extends SmallVariableConstructor {
        private SmallStringConstructor() {
        }

        @Override
        public Data.DataType getType() {
            return Data.DataType.STRING;
        }

        @Override
        public void parse(ByteBuffer b, Data data) {
            int size = b.get() & 0xFF;
            byte[] bytes = new byte[size];
            b.get(bytes);
            data.putString(new String(bytes, UTF_8));
        }
    }

    private static class SmallSymbolConstructor
    extends SmallVariableConstructor {
        private SmallSymbolConstructor() {
        }

        @Override
        public Data.DataType getType() {
            return Data.DataType.SYMBOL;
        }

        @Override
        public void parse(ByteBuffer b, Data data) {
            int size = b.get() & 0xFF;
            byte[] bytes = new byte[size];
            b.get(bytes);
            data.putSymbol(Symbol.valueOf((String)new String(bytes, ASCII)));
        }
    }

    private static class SmallBinaryConstructor
    extends SmallVariableConstructor {
        private SmallBinaryConstructor() {
        }

        @Override
        public Data.DataType getType() {
            return Data.DataType.BINARY;
        }

        @Override
        public void parse(ByteBuffer b, Data data) {
            int size = b.get() & 0xFF;
            byte[] bytes = new byte[size];
            b.get(bytes);
            data.putBinary(bytes);
        }
    }

    private static abstract class VariableConstructor
    implements TypeConstructor {
        private VariableConstructor() {
        }

        @Override
        public int size(ByteBuffer b) {
            int position = b.position();
            if (b.remaining() >= 4) {
                int size = b.getInt();
                b.position(position);
                return size + 4;
            }
            return 4;
        }
    }

    private static abstract class SmallVariableConstructor
    implements TypeConstructor {
        private SmallVariableConstructor() {
        }

        @Override
        public int size(ByteBuffer b) {
            int position = b.position();
            if (b.hasRemaining()) {
                int size = b.get() & 0xFF;
                b.position(position);
                return size + 1;
            }
            return 1;
        }
    }

    private static class UUIDConstructor
    extends Fixed16SizeConstructor {
        private UUIDConstructor() {
        }

        @Override
        public Data.DataType getType() {
            return Data.DataType.UUID;
        }

        @Override
        public void parse(ByteBuffer b, Data data) {
            data.putUUID(new UUID(b.getLong(), b.getLong()));
        }
    }

    private static class Decimal128Constructor
    extends Fixed16SizeConstructor {
        private Decimal128Constructor() {
        }

        @Override
        public Data.DataType getType() {
            return Data.DataType.DECIMAL128;
        }

        @Override
        public void parse(ByteBuffer b, Data data) {
            data.putDecimal128(new Decimal128(b.getLong(), b.getLong()));
        }
    }

    private static class Decimal64Constructor
    extends Fixed8SizeConstructor {
        private Decimal64Constructor() {
        }

        @Override
        public Data.DataType getType() {
            return Data.DataType.DECIMAL64;
        }

        @Override
        public void parse(ByteBuffer b, Data data) {
            data.putDecimal64(new Decimal64(b.getLong()));
        }
    }

    private static class TimestampConstructor
    extends Fixed8SizeConstructor {
        private TimestampConstructor() {
        }

        @Override
        public Data.DataType getType() {
            return Data.DataType.TIMESTAMP;
        }

        @Override
        public void parse(ByteBuffer b, Data data) {
            data.putTimestamp(new Date(b.getLong()));
        }
    }

    private static class DoubleConstructor
    extends Fixed8SizeConstructor {
        private DoubleConstructor() {
        }

        @Override
        public Data.DataType getType() {
            return Data.DataType.DOUBLE;
        }

        @Override
        public void parse(ByteBuffer b, Data data) {
            data.putDouble(b.getDouble());
        }
    }

    private static class LongConstructor
    extends Fixed8SizeConstructor {
        private LongConstructor() {
        }

        @Override
        public Data.DataType getType() {
            return Data.DataType.LONG;
        }

        @Override
        public void parse(ByteBuffer b, Data data) {
            data.putLong(b.getLong());
        }
    }

    private static class ULongConstructor
    extends Fixed8SizeConstructor {
        private ULongConstructor() {
        }

        @Override
        public Data.DataType getType() {
            return Data.DataType.ULONG;
        }

        @Override
        public void parse(ByteBuffer b, Data data) {
            data.putUnsignedLong(UnsignedLong.valueOf((long)b.getLong()));
        }
    }

    private static class Decimal32Constructor
    extends Fixed4SizeConstructor {
        private Decimal32Constructor() {
        }

        @Override
        public Data.DataType getType() {
            return Data.DataType.DECIMAL32;
        }

        @Override
        public void parse(ByteBuffer b, Data data) {
            data.putDecimal32(new Decimal32(b.getInt()));
        }
    }

    private static class CharConstructor
    extends Fixed4SizeConstructor {
        private CharConstructor() {
        }

        @Override
        public Data.DataType getType() {
            return Data.DataType.CHAR;
        }

        @Override
        public void parse(ByteBuffer b, Data data) {
            data.putChar(b.getInt());
        }
    }

    private static class FloatConstructor
    extends Fixed4SizeConstructor {
        private FloatConstructor() {
        }

        @Override
        public Data.DataType getType() {
            return Data.DataType.FLOAT;
        }

        @Override
        public void parse(ByteBuffer b, Data data) {
            data.putFloat(b.getFloat());
        }
    }

    private static class IntConstructor
    extends Fixed4SizeConstructor {
        private IntConstructor() {
        }

        @Override
        public Data.DataType getType() {
            return Data.DataType.INT;
        }

        @Override
        public void parse(ByteBuffer b, Data data) {
            data.putInt(b.getInt());
        }
    }

    private static class UIntConstructor
    extends Fixed4SizeConstructor {
        private UIntConstructor() {
        }

        @Override
        public Data.DataType getType() {
            return Data.DataType.UINT;
        }

        @Override
        public void parse(ByteBuffer b, Data data) {
            data.putUnsignedInteger(UnsignedInteger.valueOf((int)b.getInt()));
        }
    }

    private static class ShortConstructor
    extends Fixed2SizeConstructor {
        private ShortConstructor() {
        }

        @Override
        public Data.DataType getType() {
            return Data.DataType.SHORT;
        }

        @Override
        public void parse(ByteBuffer b, Data data) {
            data.putShort(b.getShort());
        }
    }

    private static class UShortConstructor
    extends Fixed2SizeConstructor {
        private UShortConstructor() {
        }

        @Override
        public Data.DataType getType() {
            return Data.DataType.USHORT;
        }

        @Override
        public void parse(ByteBuffer b, Data data) {
            data.putUnsignedShort(UnsignedShort.valueOf((short)b.getShort()));
        }
    }

    private static class BooleanConstructor
    extends Fixed1SizeConstructor {
        private BooleanConstructor() {
        }

        @Override
        public Data.DataType getType() {
            return Data.DataType.BOOL;
        }

        @Override
        public void parse(ByteBuffer b, Data data) {
            byte i = b.get();
            if (i != 0 && i != 1) {
                throw new IllegalArgumentException("Illegal value " + i + " for boolean");
            }
            data.putBoolean(i == 1);
        }
    }

    private static class SmallLongConstructor
    extends Fixed1SizeConstructor {
        private SmallLongConstructor() {
        }

        @Override
        public Data.DataType getType() {
            return Data.DataType.LONG;
        }

        @Override
        public void parse(ByteBuffer b, Data data) {
            data.putLong((long)b.get());
        }
    }

    private static class SmallULongConstructor
    extends Fixed1SizeConstructor {
        private SmallULongConstructor() {
        }

        @Override
        public Data.DataType getType() {
            return Data.DataType.ULONG;
        }

        @Override
        public void parse(ByteBuffer b, Data data) {
            data.putUnsignedLong(UnsignedLong.valueOf((long)(b.get() & 0xFF)));
        }
    }

    private static class SmallIntConstructor
    extends Fixed1SizeConstructor {
        private SmallIntConstructor() {
        }

        @Override
        public Data.DataType getType() {
            return Data.DataType.INT;
        }

        @Override
        public void parse(ByteBuffer b, Data data) {
            data.putInt((int)b.get());
        }
    }

    private static class SmallUIntConstructor
    extends Fixed1SizeConstructor {
        private SmallUIntConstructor() {
        }

        @Override
        public Data.DataType getType() {
            return Data.DataType.UINT;
        }

        @Override
        public void parse(ByteBuffer b, Data data) {
            data.putUnsignedInteger(UnsignedInteger.valueOf((int)(b.get() & 0xFF)));
        }
    }

    private static class ByteConstructor
    extends Fixed1SizeConstructor {
        private ByteConstructor() {
        }

        @Override
        public Data.DataType getType() {
            return Data.DataType.BYTE;
        }

        @Override
        public void parse(ByteBuffer b, Data data) {
            data.putByte(b.get());
        }
    }

    private static class UByteConstructor
    extends Fixed1SizeConstructor {
        private UByteConstructor() {
        }

        @Override
        public Data.DataType getType() {
            return Data.DataType.UBYTE;
        }

        @Override
        public void parse(ByteBuffer b, Data data) {
            data.putUnsignedByte(UnsignedByte.valueOf((byte)b.get()));
        }
    }

    private static abstract class Fixed16SizeConstructor
    implements TypeConstructor {
        private Fixed16SizeConstructor() {
        }

        @Override
        public int size(ByteBuffer b) {
            return 16;
        }
    }

    private static abstract class Fixed8SizeConstructor
    implements TypeConstructor {
        private Fixed8SizeConstructor() {
        }

        @Override
        public int size(ByteBuffer b) {
            return 8;
        }
    }

    private static abstract class Fixed4SizeConstructor
    implements TypeConstructor {
        private Fixed4SizeConstructor() {
        }

        @Override
        public int size(ByteBuffer b) {
            return 4;
        }
    }

    private static abstract class Fixed2SizeConstructor
    implements TypeConstructor {
        private Fixed2SizeConstructor() {
        }

        @Override
        public int size(ByteBuffer b) {
            return 2;
        }
    }

    private static abstract class Fixed1SizeConstructor
    implements TypeConstructor {
        private Fixed1SizeConstructor() {
        }

        @Override
        public int size(ByteBuffer b) {
            return 1;
        }
    }

    private static abstract class Fixed0SizeConstructor
    implements TypeConstructor {
        private Fixed0SizeConstructor() {
        }

        @Override
        public final int size(ByteBuffer b) {
            return 0;
        }
    }

    private static class EmptyListConstructor
    implements TypeConstructor {
        private EmptyListConstructor() {
        }

        @Override
        public Data.DataType getType() {
            return Data.DataType.LIST;
        }

        @Override
        public int size(ByteBuffer b) {
            return 0;
        }

        @Override
        public void parse(ByteBuffer b, Data data) {
            data.putList();
        }
    }

    private static class ULong0Constructor
    implements TypeConstructor {
        private ULong0Constructor() {
        }

        @Override
        public Data.DataType getType() {
            return Data.DataType.ULONG;
        }

        @Override
        public int size(ByteBuffer b) {
            return 0;
        }

        @Override
        public void parse(ByteBuffer b, Data data) {
            data.putUnsignedLong(UnsignedLong.ZERO);
        }
    }

    private static class UInt0Constructor
    implements TypeConstructor {
        private UInt0Constructor() {
        }

        @Override
        public Data.DataType getType() {
            return Data.DataType.UINT;
        }

        @Override
        public int size(ByteBuffer b) {
            return 0;
        }

        @Override
        public void parse(ByteBuffer b, Data data) {
            data.putUnsignedInteger(UnsignedInteger.ZERO);
        }
    }

    private static class FalseConstructor
    implements TypeConstructor {
        private FalseConstructor() {
        }

        @Override
        public Data.DataType getType() {
            return Data.DataType.BOOL;
        }

        @Override
        public int size(ByteBuffer b) {
            return 0;
        }

        @Override
        public void parse(ByteBuffer b, Data data) {
            data.putBoolean(false);
        }
    }

    private static class TrueConstructor
    implements TypeConstructor {
        private TrueConstructor() {
        }

        @Override
        public Data.DataType getType() {
            return Data.DataType.BOOL;
        }

        @Override
        public int size(ByteBuffer b) {
            return 0;
        }

        @Override
        public void parse(ByteBuffer b, Data data) {
            data.putBoolean(true);
        }
    }

    private static class NullConstructor
    implements TypeConstructor {
        private NullConstructor() {
        }

        @Override
        public Data.DataType getType() {
            return Data.DataType.NULL;
        }

        @Override
        public int size(ByteBuffer b) {
            return 0;
        }

        @Override
        public void parse(ByteBuffer b, Data data) {
            data.putNull();
        }
    }

    private static interface TypeConstructor {
        public Data.DataType getType();

        public int size(ByteBuffer var1);

        public void parse(ByteBuffer var1, Data var2);
    }
}

