/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.proton.driver.impl;

import java.io.IOException;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.qpid.proton.driver.Connector;
import org.apache.qpid.proton.driver.Listener;
import org.apache.qpid.proton.driver.impl.DriverImpl;
import org.apache.qpid.proton.engine.Connection;
import org.apache.qpid.proton.engine.Sasl;
import org.apache.qpid.proton.engine.Transport;
import org.apache.qpid.proton.engine.impl.TransportFactory;

class ConnectorImpl<C>
implements Connector<C> {
    private static int DEFAULT_BUFFER_SIZE = 65536;
    private static int readBufferSize = Integer.getInteger("pn.receive_buffer_size", DEFAULT_BUFFER_SIZE);
    private static int writeBufferSize = Integer.getInteger("pn.send_buffer_size", DEFAULT_BUFFER_SIZE);
    private final DriverImpl _driver;
    private final Listener<C> _listener;
    private final SocketChannel _channel;
    private final Logger _logger = Logger.getLogger("proton.driver");
    private C _context;
    private Connection _connection;
    private Transport _transport = null;
    private SelectionKey _key;
    private ConnectorState _state = ConnectorState.UNINITIALIZED;
    private boolean _inputDone = false;
    private boolean _outputDone = false;
    private boolean _closed = false;
    private boolean _selected = false;
    private boolean _readAllowed = false;

    ConnectorImpl(DriverImpl driver, Listener<C> listener, SocketChannel c, C context, SelectionKey key) {
        this._driver = driver;
        this._listener = listener;
        this._channel = c;
        this._context = context;
        this._key = key;
    }

    void selected() {
        if (!this._selected) {
            this._selected = true;
            this._driver.selectConnector(this);
            this._readAllowed = true;
        }
    }

    void unselected() {
        this._selected = false;
    }

    public boolean process() throws IOException {
        if (this.isClosed() || !this._channel.finishConnect()) {
            return false;
        }
        boolean processed = false;
        if (!this._inputDone && this.read()) {
            processed = true;
        }
        if (!this._outputDone && this.write()) {
            processed = true;
        }
        if (this._outputDone && this._inputDone) {
            this.close();
        }
        return processed;
    }

    private boolean read() throws IOException {
        if (!this._readAllowed) {
            return false;
        }
        this._readAllowed = false;
        boolean processed = false;
        int interest = this._key.interestOps();
        int capacity = this._transport.capacity();
        if (capacity == -1) {
            this._inputDone = true;
        } else {
            int bytesRead = this._channel.read(this._transport.tail());
            if (bytesRead < 0) {
                this._transport.close_tail();
                this._inputDone = true;
            } else if (bytesRead > 0) {
                this._transport.process();
                processed = true;
            }
        }
        capacity = this._transport.capacity();
        if (capacity > 0) {
            interest |= 1;
        } else {
            interest &= 0xFFFFFFFE;
            if (capacity < 0) {
                this._inputDone = true;
            }
        }
        this._key.interestOps(interest);
        return processed;
    }

    private boolean write() throws IOException {
        boolean processed = false;
        int interest = this._key.interestOps();
        boolean writeBlocked = false;
        while (this._transport.pending() >= 0 && !writeBlocked) {
            int wrote = this._channel.write(this._transport.head());
            if (wrote > 0) {
                processed = true;
                this._transport.pop(wrote);
                continue;
            }
            writeBlocked = true;
        }
        int pending = this._transport.pending();
        if (pending > 0) {
            interest |= 4;
        } else {
            interest &= 0xFFFFFFFB;
            if (pending < 0) {
                this._outputDone = true;
            }
        }
        this._key.interestOps(interest);
        return processed;
    }

    public Listener<C> listener() {
        return this._listener;
    }

    public Sasl sasl() {
        if (this._transport != null) {
            return this._transport.sasl();
        }
        return null;
    }

    public Connection getConnection() {
        return this._connection;
    }

    public void setConnection(Connection connection) {
        this._connection = connection;
        this._transport = TransportFactory.getDefaultTransportFactory().transport(this._connection);
    }

    public C getContext() {
        return this._context;
    }

    public void setContext(C context) {
        this._context = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (!this.isClosed()) {
            try {
                this._channel.close();
            }
            catch (IOException e) {
                this._logger.log(Level.SEVERE, "Exception when closing connection", e);
            }
            finally {
                this._closed = true;
                this.selected();
            }
        }
    }

    public boolean isClosed() {
        return this._closed;
    }

    public void destroy() {
        this.close();
        this._driver.removeConnector(this);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ConnectorImpl [_channel=").append(this._channel).append("]");
        return builder.toString();
    }

    static enum ConnectorState {
        UNINITIALIZED,
        OPENED,
        EOS,
        CLOSED;

    }
}

