/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.leveldb;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.activemq.command.MessageId;
import org.apache.activemq.leveldb.EntryLocator;
import org.apache.activemq.leveldb.LevelDBStore$;
import org.apache.activemq.store.ListenableFuture;
import scala.Function0;
import scala.Predef$;
import scala.ScalaObject;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ScalaSignature(bytes="\u0006\u0001\u00055d\u0001B\u0001\u0003\u0001-\u0011qbQ8v]R$un\u001e8GkR,(/\u001a\u0006\u0003\u0007\u0011\tq\u0001\\3wK2$'M\u0003\u0002\u0006\r\u0005A\u0011m\u0019;jm\u0016l\u0017O\u0003\u0002\b\u0011\u00051\u0011\r]1dQ\u0016T\u0011!C\u0001\u0004_J<7\u0001A\u000b\u0003\u0019u\u0019B\u0001A\u0007\u0016SA\u0011abE\u0007\u0002\u001f)\u0011\u0001#E\u0001\u0005Y\u0006twMC\u0001\u0013\u0003\u0011Q\u0017M^1\n\u0005Qy!AB(cU\u0016\u001cG\u000fE\u0002\u00173mi\u0011a\u0006\u0006\u00031\u0011\tQa\u001d;pe\u0016L!AG\f\u0003!1K7\u000f^3oC\ndWMR;ukJ,\u0007C\u0001\u000f\u001e\u0019\u0001!QA\b\u0001C\u0002}\u0011\u0011\u0001V\t\u0003A\u0019\u0002\"!\t\u0013\u000e\u0003\tR\u0011aI\u0001\u0006g\u000e\fG.Y\u0005\u0003K\t\u0012qAT8uQ&tw\r\u0005\u0002\"O%\u0011\u0001F\t\u0002\u0007\u0003:L(+\u001a4\u0011\u0005\u0005R\u0013BA\u0016#\u0005-\u00196-\u00197b\u001f\nTWm\u0019;\t\u000b5\u0002A\u0011\u0001\u0018\u0002\rqJg.\u001b;?)\u0005y\u0003c\u0001\u0019\u000175\t!\u0001C\u00043\u0001\t\u0007I\u0011B\u001a\u0002\u000b1\fGo\u00195\u0016\u0003Q\u0002\"!\u000e\u001e\u000e\u0003YR!a\u000e\u001d\u0002\u0015\r|gnY;se\u0016tGO\u0003\u0002:#\u0005!Q\u000f^5m\u0013\tYdG\u0001\bD_VtG\u000fR8x]2\u000bGo\u00195\t\ru\u0002\u0001\u0015!\u00035\u0003\u0019a\u0017\r^2iA!9q\b\u0001a\u0001\n\u0003\u0001\u0015!\u0002<bYV,W#A\u000e\t\u000f\t\u0003\u0001\u0019!C\u0001\u0007\u0006Ia/\u00197vK~#S-\u001d\u000b\u0003\t\u001e\u0003\"!I#\n\u0005\u0019\u0013#\u0001B+oSRDq\u0001S!\u0002\u0002\u0003\u00071$A\u0002yIEBaA\u0013\u0001!B\u0013Y\u0012A\u0002<bYV,\u0007\u0005\u000b\u0002J\u0019B\u0011\u0011%T\u0005\u0003\u001d\n\u0012\u0001B^8mCRLG.\u001a\u0005\b!\u0002\u0001\r\u0011\"\u0001R\u0003\u0015)'O]8s+\u0005\u0011\u0006CA*\\\u001d\t!\u0016L\u0004\u0002V16\taK\u0003\u0002X\u0015\u00051AH]8pizJ\u0011aI\u0005\u00035\n\nq\u0001]1dW\u0006<W-\u0003\u0002];\nIA\u000b\u001b:po\u0006\u0014G.\u001a\u0006\u00035\nBqa\u0018\u0001A\u0002\u0013\u0005\u0001-A\u0005feJ|'o\u0018\u0013fcR\u0011A)\u0019\u0005\b\u0011z\u000b\t\u00111\u0001S\u0011\u0019\u0019\u0007\u0001)Q\u0005%\u00061QM\u001d:pe\u0002Bq!\u001a\u0001A\u0002\u0013\u0005a-\u0001\u0005mSN$XM\\3s+\u00059\u0007C\u0001\bi\u0013\tIwB\u0001\u0005Sk:t\u0017M\u00197f\u0011\u001dY\u0007\u00011A\u0005\u00021\fA\u0002\\5ti\u0016tWM]0%KF$\"\u0001R7\t\u000f!S\u0017\u0011!a\u0001O\"1q\u000e\u0001Q!\n\u001d\f\u0011\u0002\\5ti\u0016tWM\u001d\u0011\t\u000fE\u0004\u0001\u0019!C\u0001e\u0006\u0011\u0011\u000eZ\u000b\u0002gB\u0011Ao^\u0007\u0002k*\u0011a\u000fB\u0001\bG>lW.\u00198e\u0013\tAXOA\u0005NKN\u001c\u0018mZ3JI\"9!\u0010\u0001a\u0001\n\u0003Y\u0018AB5e?\u0012*\u0017\u000f\u0006\u0002Ey\"9\u0001*_A\u0001\u0002\u0004\u0019\bB\u0002@\u0001A\u0003&1/A\u0002jI\u0002Bq!!\u0001\u0001\t\u0003\t\u0019!\u0001\u0004dC:\u001cW\r\u001c\u000b\u0005\u0003\u000b\tY\u0001E\u0002\"\u0003\u000fI1!!\u0003#\u0005\u001d\u0011un\u001c7fC:Dq!!\u0004\u0000\u0001\u0004\t)!A\u000bnCfLe\u000e^3seV\u0004H/\u00134Sk:t\u0017N\\4\t\u000f\u0005E\u0001\u0001\"\u0001\u0002\u0014\u0005Y\u0011n]\"b]\u000e,G\u000e\\3e)\t\t)\u0001C\u0004\u0002\u0018\u0001!\t!!\u0007\u0002\u0013\r|W\u000e\u001d7fi\u0016$WCAA\u0003\u0011\u001d\ti\u0002\u0001C\u0001\u0003?\tQ!Y<bSR$\u0012\u0001\u0012\u0005\b\u0003;\u0001A\u0011AA\u0012)\u0019\t)!!\n\u00020!A\u0011qEA\u0011\u0001\u0004\tI#\u0001\u0002qcA\u0019\u0011%a\u000b\n\u0007\u00055\"E\u0001\u0003M_:<\u0007\u0002CA\u0019\u0003C\u0001\r!a\r\u0002\u0005A\u0014\u0004cA\u001b\u00026%\u0019\u0011q\u0007\u001c\u0003\u0011QKW.Z+oSRDq!a\u000f\u0001\t\u0003\ti$A\u0002tKR$2\u0001RA \u0011\u001d\t\t%!\u000fA\u0002m\t\u0011A\u001e\u0005\b\u0003\u000b\u0002A\u0011AA$\u0003\u00191\u0017-\u001b7fIR\u0019A)!\u0013\t\u000f\u0005\u0005\u00131\ta\u0001%\"9\u0011Q\n\u0001\u0005\u0002\u0005=\u0013aA4fiR\t1\u0004C\u0004\u0002N\u0001!\t!a\u0015\u0015\u000bm\t)&a\u0016\t\u0011\u0005\u001d\u0012\u0011\u000ba\u0001\u0003SA\u0001\"!\r\u0002R\u0001\u0007\u00111\u0007\u0005\b\u00037\u0002A\u0011AA\n\u0003\u0019I7\u000fR8oK\"9\u0011q\f\u0001\u0005\u0002\u0005\u0005\u0014\u0001\u00044je\u0016d\u0015n\u001d;f]\u0016\u0014X#\u0001#\t\u000f\u0005\u0015\u0004\u0001\"\u0001\u0002h\u0005Y\u0011\r\u001a3MSN$XM\\3s)\r!\u0015\u0011\u000e\u0005\b\u0003W\n\u0019\u00071\u0001h\u0003\u0005a\u0007")
public class CountDownFuture<T>
implements ListenableFuture<T>,
ScalaObject {
    private final CountDownLatch latch = new CountDownLatch(1);
    private volatile T value;
    private Throwable error;
    private Runnable listener;
    private MessageId id;

    private CountDownLatch latch() {
        return this.latch;
    }

    public T value() {
        return this.value;
    }

    public void value_$eq(T t) {
        this.value = t;
    }

    public Throwable error() {
        return this.error;
    }

    public void error_$eq(Throwable throwable) {
        this.error = throwable;
    }

    public Runnable listener() {
        return this.listener;
    }

    public void listener_$eq(Runnable runnable) {
        this.listener = runnable;
    }

    public MessageId id() {
        return this.id;
    }

    public void id_$eq(MessageId messageId) {
        this.id = messageId;
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return false;
    }

    @Override
    public boolean isCancelled() {
        return false;
    }

    public boolean completed() {
        return this.latch().getCount() == 0L;
    }

    public void await() {
        this.latch().await();
    }

    public boolean await(long p1, TimeUnit p2) {
        return this.latch().await(p1, p2);
    }

    public void set(T v) {
        this.value_$eq(v);
        if (this.id() != null) {
            this.id().setFutureOrSequenceLong(BoxesRunTime.boxToLong((long)((EntryLocator)this.id().getEntryLocator()).seq()));
        }
        this.latch().countDown();
        this.fireListener();
    }

    public void failed(Throwable v) {
        this.error_$eq(v);
        this.latch().countDown();
        this.fireListener();
    }

    @Override
    public T get() {
        this.latch().await();
        if (this.error() == null) {
            return this.value();
        }
        throw this.error();
    }

    @Override
    public T get(long p1, TimeUnit p2) {
        if (this.latch().await(p1, p2)) {
            if (this.error() == null) {
                return this.value();
            }
            throw this.error();
        }
        throw new TimeoutException();
    }

    @Override
    public boolean isDone() {
        return this.latch().await(0L, TimeUnit.SECONDS);
    }

    public void fireListener() {
        if (this.listener() != null) {
            try {
                this.listener().run();
            }
            catch (Throwable throwable) {
                LevelDBStore$.MODULE$.warn(throwable, (Function0<String>)new Serializable(this){
                    public static final long serialVersionUID;
                    private final CountDownFuture $outer;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final String apply() {
                        return new StringBuilder().append((Object)"unexpected exception on future listener ").append((Object)this.$outer.listener()).toString();
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                }, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
            }
        }
    }

    @Override
    public void addListener(Runnable l) {
        this.listener_$eq(l);
        if (this.isDone()) {
            this.fireListener();
        }
    }
}

