/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.training.evaluator;

import ai.djl.ndarray.NDArray;
import ai.djl.ndarray.NDList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public abstract class Evaluator {
    private String name;
    protected Map<String, Long> totalInstances;

    public Evaluator(String name) {
        this.name = name;
        this.totalInstances = new ConcurrentHashMap<String, Long>();
    }

    public String getName() {
        return this.name;
    }

    public abstract NDArray evaluate(NDList var1, NDList var2);

    public abstract void addAccumulator(String var1);

    public abstract void updateAccumulator(String var1, NDList var2, NDList var3);

    public abstract void resetAccumulator(String var1);

    public abstract float getAccumulator(String var1);

    protected void checkLabelShapes(NDArray labels, NDArray predictions, boolean checkDimOnly) {
        if (labels.getShape().get(0) != predictions.getShape().get(0)) {
            throw new IllegalArgumentException("The size of labels(" + labels.size() + ") does not match that of predictions(" + predictions.size() + ")");
        }
        if (!checkDimOnly && !labels.getShape().equals(predictions.getShape())) {
            throw new IllegalArgumentException("The shape of labels(" + labels.getShape() + ") does not match that of predictions(" + predictions.getShape() + ")");
        }
    }

    protected void checkLabelShapes(NDArray labels, NDArray predictions) {
        this.checkLabelShapes(labels, predictions, true);
    }
}

