/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.basicdataset.tabular;

import ai.djl.ndarray.NDArray;
import ai.djl.ndarray.NDList;
import ai.djl.ndarray.NDManager;
import ai.djl.ndarray.types.DataType;
import ai.djl.translate.TranslateException;
import ai.djl.translate.Translator;
import ai.djl.translate.TranslatorContext;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.List;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVPrinter;
import org.apache.commons.csv.CSVRecord;

public class CsvTranslator
implements Translator<String, String> {
    private final CSVFormat csvFormat = CSVFormat.INFORMIX_UNLOAD_CSV;

    public NDList processInput(TranslatorContext ctx, String csvData) throws TranslateException {
        NDList nDList;
        block13: {
            StringReader reader = new StringReader(csvData);
            CSVParser parser = this.csvFormat.parse((Reader)reader);
            try {
                List records = parser.getRecords();
                if (records.isEmpty()) {
                    throw new TranslateException("CSV data is empty");
                }
                int rowStart = 0;
                if (this.isHeaderRow((CSVRecord)records.get(0))) {
                    rowStart = 1;
                }
                int numRows = records.size() - rowStart;
                int expectedCols = ((CSVRecord)records.get(rowStart)).size();
                float[][] data = new float[numRows][expectedCols];
                for (int i = 0; i < numRows; ++i) {
                    CSVRecord record = (CSVRecord)records.get(i + rowStart);
                    if (record.size() != expectedCols) {
                        throw new TranslateException("Row " + record.getRecordNumber() + " has " + record.size() + " columns, expected " + expectedCols);
                    }
                    for (int j = 0; j < expectedCols; ++j) {
                        data[i][j] = this.parseFloat(record.get(j), record.getRecordNumber(), j);
                    }
                }
                NDManager manager = ctx.getNDManager();
                NDArray ndArray = manager.create(data);
                nDList = new NDList(new NDArray[]{ndArray});
                if (parser == null) break block13;
            }
            catch (Throwable throwable) {
                try {
                    if (parser != null) {
                        try {
                            parser.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new TranslateException("Failed to process CSV input", (Throwable)e);
                }
            }
            parser.close();
        }
        return nDList;
    }

    private boolean isHeaderRow(CSVRecord record) {
        for (String cell : record) {
            if (!this.isNumeric(cell.trim())) continue;
            return false;
        }
        return true;
    }

    private boolean isNumeric(String str) {
        if (str == null || str.isEmpty()) {
            return false;
        }
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            char c = str.charAt(i);
            if (c >= '0' && c <= '9' || c == '-' || c == '.' || c == 'e' || c == 'E' || c == '+') continue;
            return false;
        }
        return true;
    }

    private float parseFloat(String value, long row, int col) throws TranslateException {
        if (value == null || value.isEmpty()) {
            return Float.NaN;
        }
        int len = value.length();
        if ((value.charAt(0) <= ' ' || value.charAt(len - 1) <= ' ') && (value = value.trim()).isEmpty()) {
            return Float.NaN;
        }
        try {
            return Float.parseFloat(value);
        }
        catch (NumberFormatException e) {
            throw new TranslateException("Non-numeric value '" + value + "' at row " + row + ", column " + col, (Throwable)e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public String processOutput(TranslatorContext ctx, NDList list) throws TranslateException {
        NDArray array = list.singletonOrThrow();
        try (StringWriter writer = new StringWriter();){
            String string;
            try (CSVPrinter printer = new CSVPrinter((Appendable)writer, this.csvFormat);){
                float[] data = array.toType(DataType.FLOAT32, false).toFloatArray();
                long[] shape = array.getShape().getShape();
                if (shape.length == 1) {
                    this.printRow(printer, data, 0, data.length);
                } else if (shape.length == 2) {
                    int rows = (int)shape[0];
                    int cols = (int)shape[1];
                    for (int i = 0; i < rows; ++i) {
                        this.printRow(printer, data, i * cols, cols);
                    }
                } else {
                    throw new TranslateException("Only 1D or 2D arrays supported, found shape: " + array.getShape());
                }
                string = writer.toString();
            }
            return string;
        }
        catch (IOException e) {
            throw new TranslateException("Failed to generate CSV output", (Throwable)e);
        }
    }

    private void printRow(CSVPrinter printer, float[] data, int offset, int length) throws IOException {
        for (int i = 0; i < length; ++i) {
            printer.print((Object)Float.valueOf(data[offset + i]));
        }
        printer.println();
    }
}

