/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.DataType;
import org.tensorflow.types.family.TNumber;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="ReverseSequence", inputsClass=Inputs.class)
public final class ReverseSequence<T extends TType>
extends RawOp
implements Operand<T> {
    public static final String OP_NAME = "ReverseSequence";
    private Output<T> output;

    public ReverseSequence(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.output = operation.output(outputIdx++);
    }

    public static <T extends TType> ReverseSequence<T> create(Scope scope, Operand<T> input, Operand<? extends TNumber> seqLengths, Long seqDim, Options ... options) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInput(input.asOutput());
        opBuilder.addInput(seqLengths.asOutput());
        opBuilder.setAttr("seq_dim", seqDim);
        if (options != null) {
            for (Options opts : options) {
                if (opts.batchDim == null) continue;
                opBuilder.setAttr("batch_dim", opts.batchDim);
            }
        }
        return new ReverseSequence<T>(opBuilder.build());
    }

    public static Options batchDim(Long batchDim) {
        return new Options().batchDim(batchDim);
    }

    public Output<T> output() {
        return this.output;
    }

    @Override
    public Output<T> asOutput() {
        return this.output;
    }

    @OpInputsMetadata(outputsClass=ReverseSequence.class)
    public static class Inputs<T extends TType>
    extends RawOpInputs<ReverseSequence<T>> {
        public final Operand<T> input;
        public final Operand<? extends TNumber> seqLengths;
        public final long seqDim;
        public final long batchDim;
        public final DataType T;
        public final DataType Tlen;

        public Inputs(GraphOperation op) {
            super(new ReverseSequence(op), op, Arrays.asList("seq_dim", "batch_dim", "T", "Tlen"));
            int inputIndex = 0;
            this.input = op.input(inputIndex++);
            this.seqLengths = op.input(inputIndex++);
            this.seqDim = op.attributes().getAttrInt("seq_dim");
            this.batchDim = op.attributes().getAttrInt("batch_dim");
            this.T = op.attributes().getAttrType("T");
            this.Tlen = op.attributes().getAttrType("Tlen");
        }
    }

    public static class Options {
        private Long batchDim;

        private Options() {
        }

        public Options batchDim(Long batchDim) {
            this.batchDim = batchDim;
            return this;
        }
    }
}

