/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.nn;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.DataType;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="BatchNormWithGlobalNormalization", inputsClass=Inputs.class)
public final class BatchNormWithGlobalNormalization<T extends TType>
extends RawOp
implements Operand<T> {
    public static final String OP_NAME = "BatchNormWithGlobalNormalization";
    private Output<T> result;

    public BatchNormWithGlobalNormalization(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.result = operation.output(outputIdx++);
    }

    public static <T extends TType> BatchNormWithGlobalNormalization<T> create(Scope scope, Operand<T> t, Operand<T> m, Operand<T> v, Operand<T> beta, Operand<T> gamma, Float varianceEpsilon, Boolean scaleAfterNormalization) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInput(t.asOutput());
        opBuilder.addInput(m.asOutput());
        opBuilder.addInput(v.asOutput());
        opBuilder.addInput(beta.asOutput());
        opBuilder.addInput(gamma.asOutput());
        opBuilder.setAttr("variance_epsilon", varianceEpsilon.floatValue());
        opBuilder.setAttr("scale_after_normalization", scaleAfterNormalization);
        return new BatchNormWithGlobalNormalization<T>(opBuilder.build());
    }

    public Output<T> result() {
        return this.result;
    }

    @Override
    public Output<T> asOutput() {
        return this.result;
    }

    @OpInputsMetadata(outputsClass=BatchNormWithGlobalNormalization.class)
    public static class Inputs<T extends TType>
    extends RawOpInputs<BatchNormWithGlobalNormalization<T>> {
        public final Operand<T> t;
        public final Operand<T> m;
        public final Operand<T> v;
        public final Operand<T> beta;
        public final Operand<T> gamma;
        public final DataType T;
        public final float varianceEpsilon;
        public final boolean scaleAfterNormalization;

        public Inputs(GraphOperation op) {
            super(new BatchNormWithGlobalNormalization(op), op, Arrays.asList("T", "variance_epsilon", "scale_after_normalization"));
            int inputIndex = 0;
            this.t = op.input(inputIndex++);
            this.m = op.input(inputIndex++);
            this.v = op.input(inputIndex++);
            this.beta = op.input(inputIndex++);
            this.gamma = op.input(inputIndex++);
            this.T = op.attributes().getAttrType("T");
            this.varianceEpsilon = op.attributes().getAttrFloat("variance_epsilon");
            this.scaleAfterNormalization = op.attributes().getAttrBool("scale_after_normalization");
        }
    }
}

