/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.tpu;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.types.TFloat32;

@OpMetadata(opType="RetrieveTPUEmbeddingADAMParameters", inputsClass=Inputs.class)
public final class RetrieveTPUEmbeddingADAMParameters
extends RawOp {
    public static final String OP_NAME = "RetrieveTPUEmbeddingADAMParameters";
    private Output<TFloat32> parameters;
    private Output<TFloat32> momenta;
    private Output<TFloat32> velocities;

    public RetrieveTPUEmbeddingADAMParameters(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.parameters = operation.output(outputIdx++);
        this.momenta = operation.output(outputIdx++);
        this.velocities = operation.output(outputIdx++);
    }

    public static RetrieveTPUEmbeddingADAMParameters create(Scope scope, Long numShards, Long shardId, Options ... options) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.setAttr("num_shards", numShards);
        opBuilder.setAttr("shard_id", shardId);
        if (options != null) {
            for (Options opts : options) {
                if (opts.tableId != null) {
                    opBuilder.setAttr("table_id", opts.tableId);
                }
                if (opts.tableName != null) {
                    opBuilder.setAttr("table_name", opts.tableName);
                }
                if (opts.config == null) continue;
                opBuilder.setAttr("config", opts.config);
            }
        }
        return new RetrieveTPUEmbeddingADAMParameters(opBuilder.build());
    }

    public static Options tableId(Long tableId) {
        return new Options().tableId(tableId);
    }

    public static Options tableName(String tableName) {
        return new Options().tableName(tableName);
    }

    public static Options config(String config) {
        return new Options().config(config);
    }

    public Output<TFloat32> parameters() {
        return this.parameters;
    }

    public Output<TFloat32> momenta() {
        return this.momenta;
    }

    public Output<TFloat32> velocities() {
        return this.velocities;
    }

    @OpInputsMetadata(outputsClass=RetrieveTPUEmbeddingADAMParameters.class)
    public static class Inputs
    extends RawOpInputs<RetrieveTPUEmbeddingADAMParameters> {
        public final long tableId;
        public final String tableName;
        public final long numShards;
        public final long shardId;
        public final String config;

        public Inputs(GraphOperation op) {
            super(new RetrieveTPUEmbeddingADAMParameters(op), op, Arrays.asList("table_id", "table_name", "num_shards", "shard_id", "config"));
            boolean inputIndex = false;
            this.tableId = op.attributes().getAttrInt("table_id");
            this.tableName = op.attributes().getAttrString("table_name");
            this.numShards = op.attributes().getAttrInt("num_shards");
            this.shardId = op.attributes().getAttrInt("shard_id");
            this.config = op.attributes().getAttrString("config");
        }
    }

    public static class Options {
        private Long tableId;
        private String tableName;
        private String config;

        private Options() {
        }

        public Options tableId(Long tableId) {
            this.tableId = tableId;
            return this;
        }

        public Options tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public Options config(String config) {
            this.config = config;
            return this;
        }
    }
}

