/*
 * Decompiled with CFR 0.152.
 */
package hex;

import hex.LinkFunction;
import hex.genmodel.utils.LinkFunctionType;

class InverseFunction
extends LinkFunction {
    public InverseFunction() {
        this.linkFunctionType = LinkFunctionType.inverse;
    }

    @Override
    public double link(double f) {
        double xx = f < 0.0 ? Math.min(-1.0E-5, f) : Math.max(-1.0E-5, f);
        return 1.0 / xx;
    }

    @Override
    public double linkInv(double f) {
        return this.link(f);
    }

    @Override
    public String linkInvString(String f) {
        if (Integer.parseInt(f) < 0) {
            return "1.0/Math.min(-1e-5, " + f + ")";
        }
        return "1.0/Math.max(1e-5, " + f + ")";
    }
}

