/*
 * Decompiled with CFR 0.152.
 */
package hex;

import hex.Distribution;
import water.Iced;
import water.Key;
import water.MRTask;
import water.Scope;
import water.fvec.Chunk;
import water.fvec.Vec;

public class MeanResidualDeviance
extends Iced {
    public Vec _actuals;
    public Vec _preds;
    public Vec _weights;
    public Distribution _dist;
    public double meanResidualDeviance;

    public MeanResidualDeviance(Distribution dist, Vec preds, Vec actuals, Vec weights) {
        this._preds = preds;
        this._actuals = actuals;
        this._weights = weights;
        this._dist = dist;
    }

    private void init() throws IllegalArgumentException {
        if (this._actuals == null || this._preds == null) {
            throw new IllegalArgumentException("Missing actual targets or predicted values!");
        }
        if (this._actuals.length() != this._preds.length()) {
            throw new IllegalArgumentException("Both arguments must have the same length (" + this._actuals.length() + "!=" + this._preds.length() + ")!");
        }
        if (!this._actuals.isNumeric()) {
            throw new IllegalArgumentException("Actual target column must be numeric!");
        }
        if (this._preds.isCategorical()) {
            throw new IllegalArgumentException("Predicted targets cannot be class labels, expect continuous values.");
        }
        if (this._weights != null && !this._weights.isNumeric()) {
            throw new IllegalArgumentException("Observation weights must be numeric.");
        }
        if (!this._actuals.group().equals(this._preds.group())) {
            this._preds = this._actuals.align(this._preds);
            Scope.track(this._preds);
            if (this._weights != null) {
                this._weights = this._actuals.align(this._weights);
                Scope.track(this._weights);
            }
        }
    }

    public MeanResidualDeviance exec() {
        Scope.enter();
        this.init();
        try {
            MeanResidualBuilder gt = new MeanResidualBuilder(this._dist);
            gt = this._weights != null ? (MeanResidualBuilder)gt.doAll(this._actuals, this._preds, this._weights) : (MeanResidualBuilder)gt.doAll(this._actuals, this._preds);
            this.meanResidualDeviance = gt._mean_residual_deviance;
        }
        finally {
            Scope.exit(new Key[0]);
        }
        return this;
    }

    public static class MeanResidualBuilder
    extends MRTask<MeanResidualBuilder> {
        public double _mean_residual_deviance;
        private double _wcount;
        private Distribution _dist;

        MeanResidualBuilder(Distribution dist) {
            this._dist = dist;
        }

        @Override
        public void map(Chunk ca, Chunk cp) {
            this.map(ca, cp, (Chunk)null);
        }

        @Override
        public void map(Chunk ca, Chunk cp, Chunk cw) {
            this._mean_residual_deviance = 0.0;
            this._wcount = 0.0;
            int len = Math.min(ca._len, cp._len);
            for (int i = 0; i < len; ++i) {
                if (ca.isNA(i) || cp.isNA(i)) continue;
                double a = ca.atd(i);
                double pr = cp.atd(i);
                double w = cw != null ? cw.atd(i) : 1.0;
                this.perRow(pr, a, w);
            }
        }

        public void perRow(double pr, double a, double w) {
            if (w == 0.0) {
                return;
            }
            assert (!Double.isNaN(pr));
            assert (!Double.isNaN(a));
            assert (!Double.isNaN(w));
            this._mean_residual_deviance += this._dist.deviance(w, a, pr);
            this._wcount += w;
        }

        @Override
        public void reduce(MeanResidualBuilder other) {
            this._mean_residual_deviance += other._mean_residual_deviance;
            this._wcount += other._wcount;
        }

        @Override
        public void postGlobal() {
            this._mean_residual_deviance /= this._wcount;
        }
    }
}

