/*
 * Decompiled with CFR 0.152.
 */
package hex.createframe.postprocess;

import hex.createframe.CreateFramePostprocessStep;
import java.util.Random;
import water.MRTask;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.util.RandomBase;
import water.util.RandomUtils;

public class MissingInserterCfps
extends CreateFramePostprocessStep {
    private double p;

    public MissingInserterCfps() {
    }

    public MissingInserterCfps(double p) {
        assert (p >= 0.0 && p < 1.0) : "p should be in the range [0, 1), got " + p;
        this.p = p;
    }

    @Override
    public void exec(Frame fr, Random rng) {
        if (this.p > 0.0) {
            new InsertNAs(this.p, rng).doAll(fr);
        }
    }

    private static class InsertNAs
    extends MRTask<InsertNAs> {
        private long seed;
        private double p;

        public InsertNAs(double prob, Random random) {
            this.p = prob;
            this.seed = random.nextLong();
        }

        @Override
        public void map(Chunk[] cs) {
            int numRows = cs[0]._len;
            long chunkStart = cs[0].start();
            double denom = Math.log(1.0 - this.p);
            RandomBase rng = RandomUtils.getRNG(0L);
            for (int i = 0; i < cs.length; ++i) {
                rng.setSeed(this.seed + (long)(i * 35602489) + chunkStart * 47582L);
                int l = 0;
                while ((l += (int)Math.floor(Math.log(rng.nextDouble()) / denom)) < numRows) {
                    cs[i].set(l++, Double.NaN);
                }
            }
        }
    }
}

