/*
 * Decompiled with CFR 0.152.
 */
package hex.genmodel.algos.gam;

import hex.genmodel.algos.gam.GamUtilsISplines;
import java.io.Serializable;

public class NBSplinesTypeII
implements Serializable {
    public final int _order;
    private final int _nKnots;
    private final double[] _knots;
    public final int _totBasisFuncs;
    public final BSplineBasis[] _basisFuncs;

    public NBSplinesTypeII(int m, double[] knots) {
        this._order = m;
        this._nKnots = knots.length;
        this._totBasisFuncs = this._nKnots + this._order - 2;
        this._knots = GamUtilsISplines.fillKnots(knots, m);
        this._basisFuncs = NBSplinesTypeII.genBasisFunctions(this._totBasisFuncs, this._order, this._knots);
    }

    private static BSplineBasis[] genBasisFunctions(int totBasisFuncs, int order, double[] knots) {
        BSplineBasis[] basisFuncs = new BSplineBasis[totBasisFuncs];
        for (int index = 0; index < totBasisFuncs; ++index) {
            basisFuncs[index] = NBSplinesTypeII.formOneBasisFunc(index, order, knots);
        }
        return basisFuncs;
    }

    private static BSplineBasis formOneBasisFunc(int knotIndex, int order, double[] knots) {
        if (order == 1) {
            return new BSplineBasis(knotIndex, order, knots);
        }
        BSplineBasis oneBasis = new BSplineBasis(knotIndex, order, knots);
        oneBasis._first = NBSplinesTypeII.formOneBasisFunc(knotIndex, order - 1, knots);
        oneBasis._second = NBSplinesTypeII.formOneBasisFunc(knotIndex + 1, order - 1, knots);
        return oneBasis;
    }

    public void gamify(double[] gamifiedValues, double value) {
        if (gamifiedValues == null) {
            gamifiedValues = new double[this._totBasisFuncs];
        }
        for (int index = 0; index < this._totBasisFuncs; ++index) {
            gamifiedValues[index] = BSplineBasis.evaluate(value, this._basisFuncs[index]);
        }
    }

    public static class BSplineBasis
    implements Serializable {
        public double[] _knots;
        private double[] _numerator;
        private double[] _oneOverdenominator;
        private BSplineBasis _first = null;
        private BSplineBasis _second = null;

        public BSplineBasis(int index, int order, double[] knots) {
            this._knots = GamUtilsISplines.extractKnots(index, order, knots);
            int knotsizeDiff = order + 1 - this._knots.length;
            if (knotsizeDiff > 0) {
                double[] extendKnots = new double[knots.length + knotsizeDiff];
                System.arraycopy(this._knots, 0, extendKnots, 0, this._knots.length);
                double lastKnot = this._knots[this._knots.length - 1];
                for (int kIndex = this._knots.length; kIndex < extendKnots.length; ++kIndex) {
                    extendKnots[kIndex] = lastKnot;
                }
                this._knots = extendKnots;
            }
            this._numerator = GamUtilsISplines.formNumerator(order, this._knots);
            this._oneOverdenominator = GamUtilsISplines.formDenominator(order, this._knots);
        }

        public static double evaluate(double value, BSplineBasis root) {
            if (value < root._knots[0] || value >= root._knots[root._knots.length - 1]) {
                return 0.0;
            }
            if (root._first != null) {
                return (value - root._numerator[0]) * root._oneOverdenominator[0] * BSplineBasis.evaluate(value, root._first) + (root._numerator[1] - value) * root._oneOverdenominator[1] * BSplineBasis.evaluate(value, root._second);
            }
            return 1.0;
        }
    }
}

