/*
 * Decompiled with CFR 0.152.
 */
package hex.genmodel.algos.klime;

import hex.ModelCategory;
import hex.genmodel.MojoModel;
import hex.genmodel.algos.glm.GlmMojoModel;
import java.util.EnumSet;

public class KLimeMojoModel
extends MojoModel {
    MojoModel _clusteringModel;
    MojoModel _globalRegressionModel;
    MojoModel[] _clusterRegressionModels;
    int[] _rowSubsetMap;

    @Override
    public EnumSet<ModelCategory> getModelCategories() {
        return EnumSet.of(ModelCategory.Regression, ModelCategory.KLime);
    }

    KLimeMojoModel(String[] columns, String[][] domains, String responseColumn) {
        super(columns, domains, responseColumn);
    }

    @Override
    public double[] score0(double[] row, double[] preds) {
        assert (preds.length == row.length + 2);
        double[] predsSubset = new double[this._clusteringModel.nfeatures() + 2];
        double[] rowSubset = new double[this._clusteringModel.nfeatures()];
        for (int j = 0; j < this._clusteringModel._names.length; ++j) {
            rowSubset[j] = row[this._rowSubsetMap[j]];
        }
        this._clusteringModel.score0(rowSubset, predsSubset);
        int cluster = (int)predsSubset[0];
        GlmMojoModel regressionModel = this.getRegressionModel(cluster);
        regressionModel.score0(row, preds);
        preds[1] = cluster;
        for (int i = 2; i < preds.length; ++i) {
            preds[i] = Double.NaN;
        }
        regressionModel.applyCoefficients(row, preds, 2);
        return preds;
    }

    public GlmMojoModel getRegressionModel(int cluster) {
        return (GlmMojoModel)(this._clusterRegressionModels[cluster] != null ? this._clusterRegressionModels[cluster] : this._globalRegressionModel);
    }

    @Override
    public int getPredsSize() {
        return this.nfeatures() + 2;
    }
}

