/*
 * Decompiled with CFR 0.152.
 */
package hex.grid;

import hex.ScoreKeeper;
import water.Iced;
import water.fvec.Frame;

public class HyperSpaceSearchCriteria
extends Iced {
    public final Strategy _strategy;

    public final Strategy strategy() {
        return this._strategy;
    }

    public StoppingCriteria stoppingCriteria() {
        return null;
    }

    public HyperSpaceSearchCriteria(Strategy strategy) {
        this._strategy = strategy;
    }

    public static final class SequentialSearchCriteria
    extends HyperSpaceSearchCriteria {
        private StoppingCriteria _stoppingCriteria;

        public SequentialSearchCriteria() {
            this(new StoppingCriteria());
        }

        public SequentialSearchCriteria(StoppingCriteria stoppingCriteria) {
            super(Strategy.Sequential);
            this._stoppingCriteria = stoppingCriteria;
        }

        @Override
        public StoppingCriteria stoppingCriteria() {
            return this._stoppingCriteria;
        }
    }

    public static final class RandomDiscreteValueSearchCriteria
    extends HyperSpaceSearchCriteria {
        private long _seed = -1L;
        private StoppingCriteria _stoppingCriteria = new StoppingCriteria();

        public RandomDiscreteValueSearchCriteria() {
            super(Strategy.RandomDiscrete);
        }

        @Override
        public StoppingCriteria stoppingCriteria() {
            return this._stoppingCriteria;
        }

        public long seed() {
            return this._seed;
        }

        public int max_models() {
            return this._stoppingCriteria._max_models;
        }

        public double max_runtime_secs() {
            return this._stoppingCriteria._max_runtime_secs;
        }

        public int stopping_rounds() {
            return this._stoppingCriteria._stopping_rounds;
        }

        public ScoreKeeper.StoppingMetric stopping_metric() {
            return this._stoppingCriteria._stopping_metric;
        }

        public double stopping_tolerance() {
            return this._stoppingCriteria._stopping_tolerance;
        }

        public static double default_stopping_tolerance_for_frame(Frame frame) {
            return Math.min(0.05, Math.max(0.001, 1.0 / Math.sqrt((1.0 - frame.naFraction()) * (double)frame.numRows())));
        }

        public void set_default_stopping_tolerance_for_frame(Frame frame) {
            this.set_stopping_tolerance(RandomDiscreteValueSearchCriteria.default_stopping_tolerance_for_frame(frame));
        }

        public void set_seed(long seed) {
            this._seed = seed;
        }

        public void set_max_models(int max_models) {
            this.cloneStoppingCriteria()._max_models = max_models;
        }

        public void set_max_runtime_secs(double max_runtime_secs) {
            this.cloneStoppingCriteria()._max_runtime_secs = max_runtime_secs;
        }

        public void set_stopping_rounds(int stopping_rounds) {
            this.cloneStoppingCriteria()._stopping_rounds = stopping_rounds;
        }

        public void set_stopping_metric(ScoreKeeper.StoppingMetric stopping_metric) {
            this.cloneStoppingCriteria()._stopping_metric = stopping_metric;
        }

        public void set_stopping_tolerance(double stopping_tolerance) {
            this.cloneStoppingCriteria()._stopping_tolerance = stopping_tolerance;
        }

        private StoppingCriteria cloneStoppingCriteria() {
            this._stoppingCriteria = (StoppingCriteria)this._stoppingCriteria.clone();
            return this._stoppingCriteria;
        }
    }

    public static final class CartesianSearchCriteria
    extends HyperSpaceSearchCriteria {
        public CartesianSearchCriteria() {
            super(Strategy.Cartesian);
        }
    }

    public static class StoppingCriteria
    extends Iced {
        private int _max_models = 0;
        private double _max_runtime_secs = 0.0;
        private ScoreKeeper.StoppingMetric _stopping_metric = ScoreKeeper.StoppingMetric.AUTO;
        private int _stopping_rounds = 0;
        private double _stopping_tolerance = 0.001;

        public static Builder create() {
            return new Builder();
        }

        public int getMaxModels() {
            return this._max_models;
        }

        public double getMaxRuntimeSecs() {
            return this._max_runtime_secs;
        }

        public int getStoppingRounds() {
            return this._stopping_rounds;
        }

        public ScoreKeeper.StoppingMetric getStoppingMetric() {
            return this._stopping_metric;
        }

        public double getStoppingTolerance() {
            return this._stopping_tolerance;
        }

        public static class Builder {
            private StoppingCriteria _criteria = new StoppingCriteria();

            public Builder maxModels(int maxModels) {
                this._criteria._max_models = maxModels;
                return this;
            }

            public Builder maxRuntimeSecs(double maxRuntimeSecs) {
                this._criteria._max_runtime_secs = maxRuntimeSecs;
                return this;
            }

            public Builder stoppingMetric(ScoreKeeper.StoppingMetric stoppingMetric) {
                this._criteria._stopping_metric = stoppingMetric;
                return this;
            }

            public Builder stoppingRounds(int stoppingRounds) {
                this._criteria._stopping_rounds = stoppingRounds;
                return this;
            }

            public Builder stoppingTolerance(double stoppingTolerance) {
                this._criteria._stopping_tolerance = stoppingTolerance;
                return this;
            }

            public StoppingCriteria build() {
                return this._criteria;
            }
        }
    }

    public static enum Strategy {
        Unknown,
        Cartesian,
        RandomDiscrete,
        Sequential;

    }
}

