/*
 * Decompiled with CFR 0.152.
 */
package no.priv.garshol.duke;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.NavigableMap;
import no.priv.garshol.duke.AbstractCmdlineTool;
import no.priv.garshol.duke.DukeException;
import no.priv.garshol.duke.databases.AbstractBlockingDatabase;
import no.priv.garshol.duke.databases.KeyFunction;
import no.priv.garshol.duke.databases.MapDBBlockingDatabase;
import org.xml.sax.SAXException;

public class DatabaseStatistics
extends AbstractCmdlineTool {
    public static void main(String[] argv) throws IOException, SAXException {
        new DatabaseStatistics().run(argv);
    }

    public void run(String[] argv) throws IOException, SAXException {
        argv = this.init(argv, 1, 1);
        if (!(this.database instanceof AbstractBlockingDatabase)) {
            System.out.println("ERR: Only blocking databases are supported.");
            System.exit(2);
        }
        AbstractBlockingDatabase db = (AbstractBlockingDatabase)this.database;
        for (KeyFunction func : db.getKeyFunctions()) {
            System.out.println("\n===== " + func);
            HashMap<Integer, Counter> sizes = new HashMap<Integer, Counter>();
            NavigableMap blocks = db.getBlocks(func);
            for (Object block : blocks.values()) {
                int size;
                if (block instanceof String[]) {
                    size = ((String[])block).length;
                } else if (block instanceof MapDBBlockingDatabase.Block) {
                    size = ((MapDBBlockingDatabase.Block)block).getIds().length;
                } else {
                    throw new DukeException("Unknown block type: " + block);
                }
                Counter c = (Counter)sizes.get(size);
                if (c == null) {
                    c = new Counter(size);
                    sizes.put(size, c);
                }
                ++c.count;
            }
            ArrayList counters = new ArrayList(sizes.values());
            Collections.sort(counters);
            for (Counter c : counters) {
                System.out.println("" + c.size + ": " + c.count);
            }
        }
    }

    @Override
    protected void usage() {
        System.out.println("");
        System.out.println("java no.priv.garshol.duke.DatabaseStatistics <cfgfile>");
        System.out.println("");
        System.out.println("  --reindex: Reindex all records before counting");
    }

    static class Counter
    implements Comparable<Counter> {
        int size;
        int count;

        public Counter(int size) {
            this.size = size;
        }

        @Override
        public int compareTo(Counter c) {
            return this.size - c.size;
        }
    }
}

