/*
 * Decompiled with CFR 0.152.
 */
package no.priv.garshol.duke;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Properties;
import no.priv.garshol.duke.DukeException;
import no.priv.garshol.duke.EquivalenceClassDatabase;
import no.priv.garshol.duke.utils.JDBCUtils;

public class JDBCEquivalenceClassDatabase
implements EquivalenceClassDatabase {
    private Statement stmt;
    private int nextclassid;

    public JDBCEquivalenceClassDatabase(String driverklass, String jdbcuri, String dbtype, Properties props) {
        this.stmt = JDBCUtils.open(driverklass, jdbcuri, props);
        this.init();
        this.nextclassid = this.getNextClassId();
    }

    @Override
    public int getClassCount() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<Collection<String>> getClasses() {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<String> getClass(String id) {
        int clid = JDBCUtils.queryForInt(this.stmt, "select clid from classes where id = '" + id + "'", -1);
        ArrayList<String> ids = new ArrayList<String>();
        try {
            ResultSet rs = this.stmt.executeQuery("select id from classes where clid = " + clid);
            try {
                while (rs.next()) {
                    ids.add(rs.getString(1));
                }
            }
            finally {
                rs.close();
            }
        }
        catch (SQLException e) {
            throw new DukeException(e);
        }
        return ids;
    }

    @Override
    public void addLink(String id1, String id2) {
        int clid2;
        int clid1 = this.getClassId(id1);
        if (clid1 == (clid2 = this.getClassId(id2)) && clid1 != -1) {
            return;
        }
        if (clid1 == -1 && clid2 == -1) {
            this.addToClass(id1, this.nextclassid);
            this.addToClass(id2, this.nextclassid);
            ++this.nextclassid;
        } else if (clid1 == -1 && clid2 != -1 || clid1 != -1 && clid2 == -1) {
            if (clid1 == -1) {
                this.addToClass(id1, clid2);
            } else {
                this.addToClass(id2, clid1);
            }
        } else {
            this.merge(clid1, clid2);
        }
    }

    @Override
    public void commit() {
    }

    public int getClassId(String id) {
        return JDBCUtils.queryForInt(this.stmt, "select clid from classes where id = '" + id + "'", -1);
    }

    private void addToClass(String id, int clid) {
        try {
            this.stmt.executeUpdate("insert into classes values ('" + id + "', " + clid + ")");
        }
        catch (SQLException e) {
            throw new DukeException(e);
        }
    }

    private void merge(int clid1, int clid2) {
        try {
            this.stmt.executeUpdate("update classes set clid = " + clid1 + " where clid = " + clid2);
        }
        catch (SQLException e) {
            throw new DukeException(e);
        }
    }

    private int getNextClassId() {
        return JDBCUtils.queryForInt(this.stmt, "select max(clid) from classes", 0) + 1;
    }

    private void init() {
        if (JDBCUtils.queryHasResult(this.stmt, "select * from information_schema.tables where table_name = 'CLASSES'")) {
            return;
        }
        try {
            this.stmt.executeUpdate("create table classes (id varchar(100) not null,                       clid int not null,                       primary key (id, clid))");
        }
        catch (SQLException e) {
            throw new DukeException(e);
        }
    }
}

