/*
 * Decompiled with CFR 0.152.
 */
package no.priv.garshol.duke;

import no.priv.garshol.duke.LinkKind;
import no.priv.garshol.duke.LinkStatus;

public class Link {
    private String id1;
    private String id2;
    private LinkStatus status;
    private LinkKind kind;
    private long timestamp;
    private double confidence;

    public Link(String id1, String id2, LinkStatus status, LinkKind kind, double confidence) {
        if (id1.compareTo(id2) < 0) {
            this.id1 = id1;
            this.id2 = id2;
        } else {
            this.id1 = id2;
            this.id2 = id1;
        }
        this.status = status;
        this.kind = kind;
        this.confidence = confidence;
        this.timestamp = System.currentTimeMillis();
    }

    public Link(String id1, String id2, LinkStatus status, LinkKind kind, long timestamp, double confidence) {
        this(id1, id2, status, kind, confidence);
        this.timestamp = timestamp;
    }

    public String getID1() {
        return this.id1;
    }

    public String getID2() {
        return this.id2;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public LinkStatus getStatus() {
        return this.status;
    }

    public LinkKind getKind() {
        return this.kind;
    }

    public double getConfidence() {
        return this.confidence;
    }

    public String getOtherId(String id) {
        if (id.equals(this.id1)) {
            return this.id2;
        }
        return this.id1;
    }

    public void retract() {
        this.status = LinkStatus.RETRACTED;
        this.confidence = 0.0;
        this.timestamp = System.currentTimeMillis();
    }

    public boolean overrides(Link other) {
        if (other.getStatus() == LinkStatus.ASSERTED && this.status != LinkStatus.ASSERTED) {
            return false;
        }
        if (this.status == LinkStatus.ASSERTED && other.getStatus() != LinkStatus.ASSERTED) {
            return true;
        }
        return this.timestamp > other.getTimestamp();
    }

    public boolean equals(Object other) {
        if (!(other instanceof Link)) {
            return false;
        }
        Link olink = (Link)other;
        return olink.getID1().equals(this.id1) && olink.getID2().equals(this.id2);
    }

    public int hashCode() {
        return this.id1.hashCode() + this.id2.hashCode();
    }

    public String toString() {
        return "[Link " + this.id1 + "=" + this.id2 + " " + (Object)((Object)this.kind) + " " + (Object)((Object)this.status) + "]";
    }
}

