/*
 * Decompiled with CFR 0.152.
 */
package no.priv.garshol.duke.datasources;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import no.priv.garshol.duke.DukeException;
import no.priv.garshol.duke.Record;
import no.priv.garshol.duke.RecordImpl;
import no.priv.garshol.duke.RecordIterator;
import no.priv.garshol.duke.StatementHandler;
import no.priv.garshol.duke.datasources.Column;
import no.priv.garshol.duke.datasources.ColumnarDataSource;
import no.priv.garshol.duke.utils.NTriplesParser;

public class NTriplesDataSource
extends ColumnarDataSource {
    private String file;
    private boolean incremental = false;
    private Collection<String> types = new HashSet<String>();
    private Reader directreader;
    private static final String RDF_TYPE = "http://www.w3.org/1999/02/22-rdf-syntax-ns#type";

    public void setInputFile(String file) {
        this.file = file;
    }

    public void setAcceptTypes(String types) {
        this.types.add(types);
    }

    public void setReader(Reader reader) {
        this.directreader = reader;
    }

    public void setIncrementalMode(boolean incremental) {
        this.incremental = incremental;
    }

    @Override
    public RecordIterator getRecords() {
        if (this.directreader == null) {
            this.verifyProperty(this.file, "input-file");
        }
        try {
            Reader reader = this.directreader;
            if (reader == null) {
                reader = new InputStreamReader((InputStream)new FileInputStream(this.file), "utf-8");
            }
            if (!this.incremental) {
                RecordHandler handler = new RecordHandler(this.types);
                NTriplesParser.parse(reader, handler);
                handler.filterByTypes();
                Iterator<Record> it = handler.getRecords().values().iterator();
                return new DefaultRecordIterator(it);
            }
            return new IncrementalRecordIterator(reader);
        }
        catch (IOException e) {
            throw new DukeException(e);
        }
    }

    @Override
    protected String getSourceName() {
        return "NTriples";
    }

    private void addStatement(RecordImpl record, String subject, String property, String object) {
        Collection cols = (Collection)this.columns.get(property);
        if (cols == null) {
            if (property.equals(RDF_TYPE) && !this.types.isEmpty()) {
                this.addValue(record, subject, property, object);
            }
            return;
        }
        for (Column col : cols) {
            String cleaned = object;
            if (col.getCleaner() != null) {
                cleaned = col.getCleaner().clean(object);
            }
            if (cleaned == null || cleaned.equals("")) continue;
            this.addValue(record, subject, col.getProperty(), cleaned);
        }
    }

    private void addValue(RecordImpl record, String subject, String property, String object) {
        if (record.isEmpty()) {
            for (Column idcol : (Collection)this.columns.get("?uri")) {
                record.addValue(idcol.getProperty(), subject);
            }
        }
        record.addValue(property, object);
    }

    private boolean filterbytype(Record record) {
        if (this.types.isEmpty()) {
            return true;
        }
        boolean found = false;
        for (String value : record.getValues(RDF_TYPE)) {
            if (!this.types.contains(value)) continue;
            return true;
        }
        return false;
    }

    class IncrementalRecordIterator
    extends RecordIterator
    implements StatementHandler {
        private BufferedReader reader;
        private NTriplesParser parser;
        private Record nextrecord;
        private String subject;
        private String property;
        private String object;

        public IncrementalRecordIterator(Reader input) {
            this.reader = new BufferedReader(input);
            this.parser = new NTriplesParser(this);
            this.parseNextLine();
            this.findNextRecord();
        }

        @Override
        public boolean hasNext() {
            return this.nextrecord != null;
        }

        @Override
        public Record next() {
            Record record = this.nextrecord;
            this.findNextRecord();
            return record;
        }

        private void findNextRecord() {
            do {
                this.nextrecord = this.parseRecord();
            } while (this.nextrecord != null && !NTriplesDataSource.this.filterbytype(this.nextrecord));
        }

        private void parseNextLine() {
            this.subject = null;
            while (this.subject == null) {
                String nextline;
                try {
                    nextline = this.reader.readLine();
                }
                catch (IOException e) {
                    throw new DukeException(e);
                }
                if (nextline == null) {
                    return;
                }
                this.parser.parseLine(nextline);
            }
        }

        private Record parseRecord() {
            RecordImpl record = new RecordImpl();
            String current = this.subject;
            while (current != null && current.equals(this.subject)) {
                NTriplesDataSource.this.addStatement(record, this.subject, this.property, this.object);
                this.parseNextLine();
            }
            if (current == null) {
                return null;
            }
            return record;
        }

        @Override
        public void statement(String subject, String property, String object, boolean literal) {
            this.subject = subject;
            this.property = property;
            this.object = object;
        }
    }

    public class DefaultRecordIterator
    extends RecordIterator {
        private Record next;
        private Iterator<Record> it;

        public DefaultRecordIterator(Iterator<Record> it) {
            this.it = it;
            this.findNext();
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public Record next() {
            if (this.next == null) {
                return this.it.next();
            }
            Record tmp = this.next;
            this.findNext();
            return tmp;
        }

        private void findNext() {
            while (this.it.hasNext()) {
                this.next = this.it.next();
                if (this.next.getProperties().isEmpty()) continue;
                return;
            }
            this.next = null;
        }
    }

    class RecordHandler
    implements StatementHandler {
        private Map<String, RecordImpl> records = new HashMap<String, RecordImpl>();
        private Collection<String> types;

        public RecordHandler(Collection<String> types) {
            this.types = types;
        }

        public void filterByTypes() {
            if (this.types.isEmpty()) {
                return;
            }
            for (String uri : new ArrayList<String>(this.records.keySet())) {
                RecordImpl r = this.records.get(uri);
                if (!NTriplesDataSource.this.filterbytype(r)) {
                    this.records.remove(uri);
                    continue;
                }
                r.remove(NTriplesDataSource.RDF_TYPE);
            }
        }

        public Map<String, RecordImpl> getRecords() {
            return this.records;
        }

        @Override
        public void statement(String subject, String property, String object, boolean literal) {
            RecordImpl record = this.records.get(subject);
            if (record == null) {
                record = new RecordImpl();
                this.records.put(subject, record);
            }
            NTriplesDataSource.this.addStatement(record, subject, property, object);
        }
    }
}

