/*
 * Decompiled with CFR 0.152.
 */
package no.priv.garshol.duke.matchers;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import no.priv.garshol.duke.Configuration;
import no.priv.garshol.duke.Database;
import no.priv.garshol.duke.DukeException;
import no.priv.garshol.duke.InMemoryLinkDatabase;
import no.priv.garshol.duke.Link;
import no.priv.garshol.duke.LinkDatabase;
import no.priv.garshol.duke.LinkKind;
import no.priv.garshol.duke.LinkStatus;
import no.priv.garshol.duke.Processor;
import no.priv.garshol.duke.Property;
import no.priv.garshol.duke.Record;
import no.priv.garshol.duke.matchers.AbstractMatchListener;
import no.priv.garshol.duke.matchers.PrintMatchListener;
import no.priv.garshol.duke.utils.LinkDatabaseUtils;

public class TestFileListener
extends AbstractMatchListener {
    private Collection<Property> idprops;
    private List<Property> props;
    private LinkDatabase golddb;
    private LinkDatabase dukedb;
    private boolean debug;
    private boolean quiet;
    private boolean linkage;
    private boolean showmatches;
    private boolean pretty;
    private boolean pessimist;
    private Processor processor;
    private Database database;
    private int missed;
    private int wrongfound;
    private int unknown;
    private double f;

    public TestFileListener(String testfile, Configuration config, boolean debug, Processor processor, boolean showmatches, boolean pretty) throws IOException {
        InMemoryLinkDatabase testdb = new InMemoryLinkDatabase();
        testdb.setDoInference(true);
        LinkDatabaseUtils.loadTestFile(testfile, (LinkDatabase)testdb);
        this.init(testdb, config, debug, processor, showmatches, pretty);
    }

    public TestFileListener(LinkDatabase linkdb, Configuration config, boolean debug, Processor processor, boolean showmatches, boolean pretty) {
        this.init(linkdb, config, debug, processor, showmatches, pretty);
    }

    private void init(LinkDatabase linkdb, Configuration config, boolean debug, Processor processor, boolean showmatches, boolean pretty) {
        this.golddb = linkdb;
        this.dukedb = new InMemoryLinkDatabase();
        ((InMemoryLinkDatabase)this.dukedb).setDoInference(true);
        this.idprops = config.getIdentityProperties();
        this.props = config.getProperties();
        this.debug = debug;
        this.processor = processor;
        this.database = processor.getDatabase();
        this.linkage = !config.isDeduplicationMode();
        this.showmatches = showmatches;
        this.pretty = pretty;
    }

    public void setQuiet(boolean quiet) {
        this.quiet = quiet;
    }

    public void setPessimistic(boolean pessimist) {
        this.pessimist = pessimist;
    }

    public double getFNumber() {
        return this.f;
    }

    @Override
    public synchronized void matches(Record r1, Record r2, double confidence) {
        String id2;
        String id1 = this.getid(r1);
        Link link = this.golddb.inferLink(id1, id2 = this.getid(r2));
        if (link == null) {
            ++this.unknown;
            if (this.debug && !this.showmatches) {
                PrintMatchListener.show(r1, r2, confidence, "\nNOT IN TEST FILE", this.props, this.pretty);
            }
        } else if (link.getKind() == LinkKind.SAME) {
            this.dukedb.assertLink(new Link(id1, id2, LinkStatus.INFERRED, LinkKind.SAME, confidence));
        } else if (link.getKind() == LinkKind.DIFFERENT) {
            ++this.wrongfound;
            if (this.debug && !this.showmatches) {
                PrintMatchListener.show(r1, r2, confidence, "\nINCORRECT", this.props, this.pretty);
            }
        }
    }

    @Override
    public synchronized void noMatchFor(Record r) {
        for (Link link : this.golddb.getAllLinksFor(this.getid(r))) {
            if (link.getKind() != LinkKind.SAME) continue;
            ++this.missed;
            Record r1 = this.database.findRecordById(link.getID1());
            Record r2 = this.database.findRecordById(link.getID2());
            if (r1 != null && r2 != null) {
                if (!this.debug || this.showmatches) continue;
                PrintMatchListener.show(r1, r2, this.processor.compare(r1, r2), "\nNOT FOUND", this.props, this.pretty);
                continue;
            }
            if (!this.debug || this.showmatches) continue;
            System.out.println("\nIDENTITIES IN TEST FILE NOT FOUND IN DATA");
            System.out.println("ID1: " + link.getID1() + " -> " + r1);
            System.out.println("ID2: " + link.getID2() + " -> " + r2);
        }
    }

    @Override
    public void endProcessing() {
        int correctfound = this.dukedb.getAllLinks().size();
        int correct = 0;
        int wrong = 0;
        for (Link link : this.golddb.getAllLinks()) {
            if (link.getKind() == LinkKind.SAME) {
                ++correct;
                continue;
            }
            ++wrong;
        }
        wrong *= 2;
        int total = correctfound + this.wrongfound;
        if (this.pessimist) {
            total += this.unknown;
        }
        double precision = (double)correctfound / (double)total;
        double recall = (double)correctfound / (double)correct;
        this.f = correctfound == 0 ? 0.0 : 2.0 * (precision * recall) / (precision + recall);
        if (!this.quiet) {
            System.out.println("");
            System.out.println("Correct links found: " + correctfound + " / " + correct + " (" + this.percent(correctfound, correct) + "%)");
            System.out.println("Wrong links found: " + this.wrongfound + " / " + wrong + " (" + this.percent(this.wrongfound, wrong) + "%)");
            System.out.println("Unknown links found: " + this.unknown);
            System.out.println("Percent of links correct " + this.percent(correctfound, total) + "%, wrong " + this.percent(this.wrongfound, total) + "%, unknown " + this.percent(this.unknown, total) + "%");
            if (this.missed > 0) {
                System.out.println("Records with no link: " + this.missed);
            }
            System.out.println("Precision " + precision * 100.0 + "%, recall " + recall * 100.0 + "%, f-number " + this.f);
        }
        if (this.f > 1.0) {
            System.out.println("===== GOLDDB ======================================");
            System.out.println(this.golddb);
            for (Link link : this.golddb.getAllLinks()) {
                System.out.println(link);
            }
            System.out.println();
            System.out.println("===== DUKEDB ======================================");
            System.out.println(this.dukedb);
            for (Link link : this.dukedb.getAllLinks()) {
                System.out.println(link);
            }
        }
    }

    private String percent(int part, int total) {
        int p = (int)((double)part * 1000.0 / (double)total);
        return "" + (double)p / 10.0;
    }

    private String getid(Record r) {
        for (Property p : this.idprops) {
            String v = r.getValue(p.getName());
            if (v == null) continue;
            return v;
        }
        throw new DukeException("No identity for record " + r);
    }
}

