/*
 * Decompiled with CFR 0.152.
 */
package no.priv.garshol.duke.utils;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import no.priv.garshol.duke.DukeException;
import no.priv.garshol.duke.utils.ObjectUtils;

public class JDBCUtils {
    public static Statement open(String jndiPath) {
        try {
            InitialContext ctx = new InitialContext();
            DataSource ds = (DataSource)ctx.lookup(jndiPath);
            Connection conn = ds.getConnection();
            return conn.createStatement();
        }
        catch (NamingException e) {
            throw new DukeException("No database configuration found via JNDI at " + jndiPath, e);
        }
        catch (SQLException e) {
            throw new DukeException("Error connecting to database via " + jndiPath, e);
        }
    }

    public static Statement open(String driverklass, String jdbcuri, Properties props) {
        try {
            Driver driver = (Driver)ObjectUtils.instantiate(driverklass);
            Connection conn = driver.connect(jdbcuri, props);
            if (conn == null) {
                throw new DukeException("Couldn't connect to database at " + jdbcuri);
            }
            return conn.createStatement();
        }
        catch (SQLException e) {
            throw new DukeException(e);
        }
    }

    public static void close(Statement stmt) {
        try {
            Connection conn = stmt.getConnection();
            try {
                if (!stmt.isClosed()) {
                    stmt.close();
                }
            }
            catch (UnsupportedOperationException e) {
                stmt.close();
            }
            if (conn != null && !conn.isClosed()) {
                conn.close();
            }
        }
        catch (SQLException e) {
            throw new DukeException(e);
        }
    }

    public static boolean validate(Statement stmt) {
        try {
            Connection conn = stmt.getConnection();
            if (conn == null) {
                return false;
            }
            if (!conn.isClosed() && conn.isValid(10)) {
                return true;
            }
            stmt.close();
            conn.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int queryForInt(Statement stmt, String sql, int nullvalue) {
        try {
            ResultSet rs = stmt.executeQuery(sql);
            try {
                if (!rs.next()) {
                    int n = nullvalue;
                    return n;
                }
                int n = rs.getInt(1);
                return n;
            }
            finally {
                rs.close();
            }
        }
        catch (SQLException e) {
            throw new DukeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean queryHasResult(Statement stmt, String sql) {
        boolean bl;
        ResultSet rs = stmt.executeQuery(sql);
        try {
            bl = rs.next();
        }
        catch (Throwable throwable) {
            try {
                rs.close();
                throw throwable;
            }
            catch (SQLException e) {
                throw new DukeException(e);
            }
        }
        rs.close();
        return bl;
    }
}

