/*
 * Decompiled with CFR 0.152.
 */
package water.api;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import water.api.schemas3.FrameV3;
import water.api.schemas3.KeyV3;

public class H2oRestGsonHelper {
    public static Gson createH2oCompatibleGson() {
        return new GsonBuilder().registerTypeAdapter((Type)((Object)KeyV3.class), new KeySerializer()).registerTypeAdapter((Type)((Object)FrameV3.ColSpecifierV3.class), new ColSerializer()).create();
    }

    private static class ColSerializer
    implements JsonSerializer<FrameV3.ColSpecifierV3>,
    JsonDeserializer<FrameV3.ColSpecifierV3> {
        private ColSerializer() {
        }

        @Override
        public JsonElement serialize(FrameV3.ColSpecifierV3 col, Type typeOfCol, JsonSerializationContext context) {
            return new JsonPrimitive(col.column_name);
        }

        @Override
        public FrameV3.ColSpecifierV3 deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) {
            if (json.isJsonNull()) {
                return null;
            }
            return new FrameV3.ColSpecifierV3(json.getAsString());
        }
    }

    private static class KeySerializer
    implements JsonSerializer<KeyV3>,
    JsonDeserializer<KeyV3> {
        private KeySerializer() {
        }

        @Override
        public JsonElement serialize(KeyV3 key, Type typeOfKey, JsonSerializationContext context) {
            return new JsonPrimitive(key.name);
        }

        @Override
        public KeyV3 deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) {
            String type;
            if (json.isJsonNull()) {
                return null;
            }
            JsonObject jobj = json.getAsJsonObject();
            switch (type = jobj.get("type").getAsString()) {
                case "Key<Model>": {
                    return (KeyV3)context.deserialize(jobj, (Type)((Object)KeyV3.ModelKeyV3.class));
                }
                case "Key<Job>": {
                    return (KeyV3)context.deserialize(jobj, (Type)((Object)KeyV3.JobKeyV3.class));
                }
                case "Key<Grid>": {
                    return (KeyV3)context.deserialize(jobj, (Type)((Object)KeyV3.GridKeyV3.class));
                }
                case "Key<Frame>": {
                    return (KeyV3)context.deserialize(jobj, (Type)((Object)KeyV3.FrameKeyV3.class));
                }
            }
            throw new JsonParseException("Unable to deserialize key of type " + type);
        }
    }
}

